/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.IDGenerator;

public class AutoRefillStack
implements IDGenerator {
    static final int DEFAULT_BATCH_SIZE = 500;
    final int batchSize;
    final IDGenerator generator;
    final Deque<byte[]> idStack = new ArrayDeque<byte[]>();

    protected AutoRefillStack(IDGenerator generator, int batchSize) {
        this.batchSize = batchSize;
        this.generator = generator;
    }

    public static IDGenerator decorate(IDGenerator generator) {
        return new AutoRefillStack(generator, 500);
    }

    public static IDGenerator decorate(IDGenerator generator, int batchSize) {
        return new AutoRefillStack(generator, batchSize);
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }

    @Override
    public synchronized byte[] generate() throws GeneratorException {
        return this.popOne();
    }

    @Override
    public synchronized Deque<byte[]> batch(int size) throws GeneratorException {
        if (size < 0) {
            size = 0;
        }
        ArrayDeque<byte[]> batch = new ArrayDeque<byte[]>(size);
        while (size > 0) {
            batch.add(this.popOne());
            --size;
        }
        return batch;
    }

    byte[] popOne() throws GeneratorException {
        try {
            return this.idStack.pop();
        }
        catch (NoSuchElementException e) {
            this.idStack.addAll(this.generator.batch(this.batchSize));
            return this.popOne();
        }
    }
}

