/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid;

import java.util.HashMap;
import java.util.Map;
import org.lable.oss.uniqueid.BaseUniqueIDGenerator;
import org.lable.oss.uniqueid.Clock;
import org.lable.oss.uniqueid.IDGenerator;
import org.lable.oss.uniqueid.LocalGeneratorIdentity;
import org.lable.oss.uniqueid.ParameterUtil;
import org.lable.oss.uniqueid.bytes.Mode;

public class LocalUniqueIDGeneratorFactory {
    static final Map<String, IDGenerator> instances = new HashMap<String, IDGenerator>();

    public static synchronized IDGenerator generatorFor(int generatorId, int clusterId, Clock clock, Mode mode) {
        ParameterUtil.assertParameterWithinBounds("generatorId", 0L, 2047L, generatorId);
        ParameterUtil.assertParameterWithinBounds("clusterId", 0L, 15L, clusterId);
        String generatorAndCluster = String.format("%d_%d", generatorId, clusterId);
        if (!instances.containsKey(generatorAndCluster)) {
            LocalGeneratorIdentity identityHolder = LocalGeneratorIdentity.with(clusterId, generatorId);
            instances.putIfAbsent(generatorAndCluster, new BaseUniqueIDGenerator(identityHolder, clock, mode));
        }
        return instances.get(generatorAndCluster);
    }

    public static synchronized IDGenerator generatorFor(int generatorId, int clusterId, Mode mode) {
        return LocalUniqueIDGeneratorFactory.generatorFor(generatorId, clusterId, null, mode);
    }
}

