/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.bytes;

import org.lable.oss.uniqueid.ParameterUtil;
import org.lable.oss.uniqueid.bytes.Mode;

public class Blueprint {
    public static final long MAX_TIMESTAMP = 0x3FFFFFFFFFFL;
    public static final int MAX_SEQUENCE_COUNTER = 63;
    public static final int MAX_GENERATOR_ID = 2047;
    public static final int MAX_CLUSTER_ID = 15;
    final long timestamp;
    final int sequence;
    final int generatorId;
    final int clusterId;
    final Mode mode;

    public Blueprint(long timestamp, int sequence, int generatorId, int clusterId) {
        this(timestamp, sequence, generatorId, clusterId, Mode.SPREAD);
    }

    public Blueprint(long timestamp, int sequence, int generatorId, int clusterId, Mode mode) {
        ParameterUtil.assertParameterWithinBounds("timestamp", 0L, 0x3FFFFFFFFFFL, timestamp);
        ParameterUtil.assertParameterWithinBounds("sequence counter", 0L, 63L, sequence);
        ParameterUtil.assertParameterWithinBounds("generator-ID", 0L, 2047L, generatorId);
        ParameterUtil.assertParameterWithinBounds("cluster-ID", 0L, 15L, clusterId);
        this.timestamp = timestamp;
        this.sequence = sequence;
        this.generatorId = generatorId;
        this.clusterId = clusterId;
        this.mode = mode == null ? Mode.SPREAD : mode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getGeneratorId() {
        return this.generatorId;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String toString() {
        return String.format("{\n  mode: %s,\n  timestamp: %d,\n  sequence: %d,\n  generator: %d,\n  cluster: %d\n}", new Object[]{this.mode, this.timestamp, this.sequence, this.generatorId, this.clusterId});
    }
}

