/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.bytes;

import java.nio.ByteBuffer;
import org.lable.oss.uniqueid.ParameterUtil;
import org.lable.oss.uniqueid.bytes.Blueprint;
import org.lable.oss.uniqueid.bytes.Mode;

public class IDBuilder {
    public static byte[] build(Blueprint blueprint) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        switch (blueprint.getMode()) {
            case SPREAD: {
                long reverseTimestamp = Long.reverse(blueprint.getTimestamp());
                bb.putLong(reverseTimestamp);
                break;
            }
            case TIME_SEQUENTIAL: {
                long timestamp = blueprint.getTimestamp();
                bb.putLong(timestamp << 22);
            }
        }
        byte[] tsBytes = bb.array();
        int or = tsBytes[5] | (byte)blueprint.getSequence();
        tsBytes[5] = (byte)or;
        int flagGeneratorCluster = blueprint.getGeneratorId() << 5 & 0xE000;
        flagGeneratorCluster += (blueprint.getGeneratorId() & 0xFF) << 4;
        flagGeneratorCluster += blueprint.getClusterId();
        tsBytes[7] = (byte)(flagGeneratorCluster += blueprint.getMode().getModeMask() << 12);
        tsBytes[6] = (byte)(flagGeneratorCluster >>>= 8);
        return tsBytes;
    }

    public static Blueprint parse(byte[] id) {
        ParameterUtil.assertNotNullEightBytes(id);
        int sequence = IDBuilder.parseSequenceIdNoChecks(id);
        int generatorId = IDBuilder.parseGeneratorIdNoChecks(id);
        int clusterId = IDBuilder.parseClusterIdNoChecks(id);
        long timestamp = IDBuilder.parseTimestampNoChecks(id);
        Mode mode = IDBuilder.parseModeNoChecks(id);
        return new Blueprint(timestamp, sequence, generatorId, clusterId, mode);
    }

    public static int parseSequenceId(byte[] id) {
        ParameterUtil.assertNotNullEightBytes(id);
        return IDBuilder.parseSequenceIdNoChecks(id);
    }

    public static int parseGeneratorId(byte[] id) {
        ParameterUtil.assertNotNullEightBytes(id);
        return IDBuilder.parseGeneratorIdNoChecks(id);
    }

    public static int parseClusterId(byte[] id) {
        ParameterUtil.assertNotNullEightBytes(id);
        return IDBuilder.parseClusterIdNoChecks(id);
    }

    public static long parseTimestamp(byte[] id) {
        ParameterUtil.assertNotNullEightBytes(id);
        return IDBuilder.parseTimestampNoChecks(id);
    }

    public static Mode parseMode(byte[] id) {
        ParameterUtil.assertNotNullEightBytes(id);
        return IDBuilder.parseModeNoChecks(id);
    }

    private static int parseSequenceIdNoChecks(byte[] id) {
        return id[5] & 0x3F;
    }

    private static int parseGeneratorIdNoChecks(byte[] id) {
        return id[7] >> 4 & 0xF | id[6] << 3 & 0x700 | id[6] << 4 & 0xF0;
    }

    private static int parseClusterIdNoChecks(byte[] id) {
        return id[7] & 0xF;
    }

    private static long parseTimestampNoChecks(byte[] id) {
        Mode mode = IDBuilder.parseModeNoChecks(id);
        switch (mode) {
            case TIME_SEQUENTIAL: {
                return IDBuilder.parseTimestampNoChecksTime(id);
            }
        }
        return IDBuilder.parseTimestampNoChecksSpread(id);
    }

    private static long parseTimestampNoChecksSpread(byte[] id) {
        byte[] copy = (byte[])id.clone();
        copy[5] = (byte)(copy[5] & 0xC0);
        copy[6] = 0;
        copy[7] = 0;
        ByteBuffer bb = ByteBuffer.wrap(copy);
        return Long.reverse(bb.getLong());
    }

    private static long parseTimestampNoChecksTime(byte[] id) {
        byte[] copy = (byte[])id.clone();
        ByteBuffer bb = ByteBuffer.wrap(copy);
        long ts = bb.getLong();
        return ts >>>= 22;
    }

    private static Mode parseModeNoChecks(byte[] id) {
        int modeMask = id[6] >> 4 & 1;
        return Mode.fromModeMask(modeMask);
    }
}

