/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.shaded.google.common.base.Preconditions;
import com.shaded.google.common.base.Strings;
import com.shaded.google.common.collect.Streams;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.impl.ClientImpl;
import io.shaded.grpc.ClientInterceptor;
import io.shaded.grpc.Metadata;
import io.shaded.grpc.netty.GrpcSslContexts;
import io.shaded.netty.handler.ssl.SslContext;
import io.shaded.netty.handler.ssl.SslContextBuilder;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;

public final class ClientBuilder
implements Cloneable {
    private String target;
    private ByteSequence user;
    private ByteSequence password;
    private ExecutorService executorService;
    private String loadBalancerPolicy;
    private SslContext sslContext;
    private String authority;
    private Integer maxInboundMessageSize;
    private Map<Metadata.Key<?>, Object> headers;
    private Map<Metadata.Key<?>, Object> authHeaders;
    private List<ClientInterceptor> interceptors;
    private List<ClientInterceptor> authInterceptors;
    private ByteSequence namespace = ByteSequence.EMPTY;
    private long retryDelay = 500L;
    private long retryMaxDelay = 2500L;
    private int retryMaxAttempts = 2;
    private ChronoUnit retryChronoUnit = ChronoUnit.MILLIS;
    private Duration keepaliveTime = Duration.ofSeconds(30L);
    private Duration keepaliveTimeout = Duration.ofSeconds(10L);
    private Boolean keepaliveWithoutCalls = true;
    private Duration retryMaxDuration;
    private Duration connectTimeout;
    private boolean waitForReady = true;

    ClientBuilder() {
    }

    public String target() {
        return this.target;
    }

    public ClientBuilder target(String target) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(target), "target can't be null or empty");
        this.target = target;
        return this;
    }

    public ClientBuilder endpoints(String ... endpoints) {
        return this.endpoints((URI[])Stream.of(endpoints).map(URI::create).toArray(URI[]::new));
    }

    public ClientBuilder endpoints(URI ... endpoints) {
        return this.endpoints(Arrays.asList(endpoints));
    }

    public ClientBuilder endpoints(Iterable<URI> endpoints) {
        Preconditions.checkNotNull(endpoints, "endpoints can't be null");
        endpoints.forEach(e -> {
            if (e.getHost() == null) {
                throw new IllegalArgumentException("Unable to compute target from endpoint: '" + e + "'");
            }
        });
        String target = Streams.stream(endpoints).map(e -> e.getHost() + (e.getPort() != -1 ? ":" + e.getPort() : "")).distinct().collect(Collectors.joining(","));
        if (Strings.isNullOrEmpty(target)) {
            throw new IllegalArgumentException("Unable to compute target from endpoints: '" + endpoints + "'");
        }
        return this.target(String.format("%s://%s/%s", "ip", this.authority != null ? this.authority : "", target));
    }

    public ByteSequence user() {
        return this.user;
    }

    public ClientBuilder user(ByteSequence user) {
        Preconditions.checkNotNull(user, "user can't be null");
        this.user = user;
        return this;
    }

    public ByteSequence password() {
        return this.password;
    }

    public ClientBuilder password(ByteSequence password) {
        Preconditions.checkNotNull(password, "password can't be null");
        this.password = password;
        return this;
    }

    public ByteSequence namespace() {
        return this.namespace;
    }

    public ClientBuilder namespace(ByteSequence namespace) {
        Preconditions.checkNotNull(namespace, "namespace can't be null");
        this.namespace = namespace;
        return this;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        Preconditions.checkNotNull(executorService, "executorService can't be null");
        this.executorService = executorService;
        return this;
    }

    public ClientBuilder loadBalancerPolicy(String loadBalancerPolicy) {
        Preconditions.checkNotNull(loadBalancerPolicy, "loadBalancerPolicy can't be null");
        this.loadBalancerPolicy = loadBalancerPolicy;
        return this;
    }

    public String loadBalancerPolicy() {
        return this.loadBalancerPolicy;
    }

    public SslContext sslContext() {
        return this.sslContext;
    }

    public ClientBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ClientBuilder sslContext(Consumer<SslContextBuilder> consumer) throws SSLException {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        consumer.accept(builder);
        return this.sslContext(builder.build());
    }

    public String authority() {
        return this.authority;
    }

    public ClientBuilder authority(String authority) {
        this.authority = authority;
        return this;
    }

    public Integer maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public ClientBuilder maxInboundMessageSize(Integer maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
        return this;
    }

    public Map<Metadata.Key<?>, Object> headers() {
        return this.headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.headers);
    }

    public ClientBuilder headers(Map<Metadata.Key<?>, Object> headers) {
        this.headers = new HashMap(headers);
        return this;
    }

    public ClientBuilder header(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value);
        return this;
    }

    public Map<Metadata.Key<?>, Object> authHeaders() {
        return this.authHeaders == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.authHeaders);
    }

    public ClientBuilder authHeaders(Map<Metadata.Key<?>, Object> authHeaders) {
        this.authHeaders = new HashMap(authHeaders);
        return this;
    }

    public ClientBuilder authHeader(String key, String value) {
        if (this.authHeaders == null) {
            this.authHeaders = new HashMap();
        }
        this.authHeaders.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value);
        return this;
    }

    public List<ClientInterceptor> interceptors() {
        return this.interceptors;
    }

    public ClientBuilder interceptors(List<ClientInterceptor> interceptors) {
        this.interceptors = new ArrayList<ClientInterceptor>(interceptors);
        return this;
    }

    public ClientBuilder interceptor(ClientInterceptor interceptor, ClientInterceptor ... interceptors) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<ClientInterceptor>();
        }
        this.interceptors.add(interceptor);
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    public List<ClientInterceptor> authInterceptors() {
        return this.authInterceptors;
    }

    public ClientBuilder authInterceptors(List<ClientInterceptor> interceptors) {
        this.authInterceptors = new ArrayList<ClientInterceptor>(interceptors);
        return this;
    }

    public ClientBuilder authInterceptors(ClientInterceptor interceptor, ClientInterceptor ... interceptors) {
        if (this.authInterceptors == null) {
            this.authInterceptors = new ArrayList<ClientInterceptor>();
        }
        this.authInterceptors.add(interceptor);
        this.authInterceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    public long retryDelay() {
        return this.retryDelay;
    }

    public ClientBuilder retryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public long retryMaxDelay() {
        return this.retryMaxDelay;
    }

    public ClientBuilder retryMaxDelay(long retryMaxDelay) {
        this.retryMaxDelay = retryMaxDelay;
        return this;
    }

    public int retryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public ClientBuilder retryMaxAttempts(int retryMaxAttempts) {
        this.retryMaxAttempts = retryMaxAttempts;
        return this;
    }

    public Duration keepaliveTime() {
        return this.keepaliveTime;
    }

    public ClientBuilder keepaliveTime(Duration keepaliveTime) {
        this.keepaliveTime = keepaliveTime;
        return this;
    }

    public Duration keepaliveTimeout() {
        return this.keepaliveTimeout;
    }

    public ClientBuilder keepaliveTimeout(Duration keepaliveTimeout) {
        this.keepaliveTimeout = keepaliveTimeout;
        return this;
    }

    public Boolean keepaliveWithoutCalls() {
        return this.keepaliveWithoutCalls;
    }

    public ClientBuilder keepaliveWithoutCalls(Boolean keepaliveWithoutCalls) {
        this.keepaliveWithoutCalls = keepaliveWithoutCalls;
        return this;
    }

    public ChronoUnit retryChronoUnit() {
        return this.retryChronoUnit;
    }

    public ClientBuilder retryChronoUnit(ChronoUnit retryChronoUnit) {
        this.retryChronoUnit = retryChronoUnit;
        return this;
    }

    public Duration retryMaxDuration() {
        return this.retryMaxDuration;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public ClientBuilder retryMaxDuration(Duration retryMaxDuration) {
        this.retryMaxDuration = retryMaxDuration;
        return this;
    }

    public ClientBuilder connectTimeout(Duration connectTimeout) {
        long millis;
        if (connectTimeout != null && (long)((int)(millis = connectTimeout.toMillis())) != millis) {
            throw new IllegalArgumentException("connectTimeout outside of its bounds, max value: 2147483647");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public boolean waitForReady() {
        return this.waitForReady;
    }

    public ClientBuilder waitForReady(boolean waitForReady) {
        this.waitForReady = waitForReady;
        return this;
    }

    public Client build() {
        Preconditions.checkState(this.target != null, "please configure etcd server endpoints before build.");
        return new ClientImpl(this);
    }

    public ClientBuilder copy() {
        try {
            return (ClientBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw EtcdExceptionFactory.toEtcdException(e);
        }
    }
}

