/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.GeneratorIdentityHolder;
import org.lable.oss.uniqueid.etcd.RegistryBasedResourceClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryBasedGeneratorIdentity
implements GeneratorIdentityHolder {
    private static final Logger logger = LoggerFactory.getLogger(RegistryBasedGeneratorIdentity.class);
    private final String endpoints;
    private final String namespace;
    private final Duration acquisitionTimeout;
    private final boolean waitWhenNoResourcesAvailable;
    private final RegistryBasedResourceClaim resourceClaim;

    public RegistryBasedGeneratorIdentity(String endpoints, String namespace, String registryEntry, Duration acquisitionTimeout, boolean waitWhenNoResourcesAvailable) {
        this.endpoints = endpoints;
        this.namespace = namespace;
        this.acquisitionTimeout = acquisitionTimeout;
        this.waitWhenNoResourcesAvailable = waitWhenNoResourcesAvailable;
        try {
            this.resourceClaim = this.acquireResourceClaim(registryEntry, 0);
        }
        catch (GeneratorException e) {
            throw new RuntimeException(e);
        }
    }

    public static RegistryBasedGeneratorIdentity basedOn(String endpoints, String namespace, String registryEntry) throws IOException {
        return new RegistryBasedGeneratorIdentity(endpoints, namespace, registryEntry, Duration.ofMinutes(5L), true);
    }

    public static RegistryBasedGeneratorIdentity basedOn(String endpoints, String namespace, String registryEntry, Duration acquisitionTimeout, boolean waitWhenNoResourcesAvailable) throws IOException {
        return new RegistryBasedGeneratorIdentity(endpoints, namespace, registryEntry, acquisitionTimeout, waitWhenNoResourcesAvailable);
    }

    @Override
    public int getClusterId() throws GeneratorException {
        return this.resourceClaim.getClusterId();
    }

    @Override
    public int getGeneratorId() throws GeneratorException {
        return this.resourceClaim.getGeneratorId();
    }

    public String getRegistryEntry() {
        return this.resourceClaim.getRegistryEntry();
    }

    private RegistryBasedResourceClaim acquireResourceClaim(String registryEntry, int retries) throws GeneratorException {
        try {
            return RegistryBasedResourceClaim.claim(this::getEtcdConnection, 2048, registryEntry, this.acquisitionTimeout, this.waitWhenNoResourcesAvailable);
        }
        catch (IOException e) {
            if (retries < 3) {
                logger.warn("Connection to Etcd failed, retrying claim acquisition, attempt {}.", (Object)(retries + 1), (Object)e);
                return this.acquireResourceClaim(registryEntry, retries + 1);
            }
            logger.error("Failed to acquire resource claim after attempt {}.", (Object)(retries + 1), (Object)e);
            throw new GeneratorException(e);
        }
    }

    Client getEtcdConnection() {
        return Client.builder().endpoints(this.endpoints.split(",")).loadBalancerPolicy("round_robin").namespace(ByteSequence.from(this.namespace, StandardCharsets.UTF_8)).build();
    }

    @Override
    public void close() throws IOException {
        if (this.resourceClaim != null) {
            this.resourceClaim.close();
        }
    }
}

