/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import org.lable.oss.uniqueid.Clock;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.GeneratorIdentityHolder;
import org.lable.oss.uniqueid.IDGenerator;
import org.lable.oss.uniqueid.bytes.Blueprint;
import org.lable.oss.uniqueid.bytes.IDBuilder;
import org.lable.oss.uniqueid.bytes.Mode;

public class BaseUniqueIDGenerator
implements IDGenerator {
    protected final GeneratorIdentityHolder generatorIdentityHolder;
    private final Clock clock;
    private final Mode mode;
    long previousTimestamp = 0L;
    int sequence = 0;

    public BaseUniqueIDGenerator(GeneratorIdentityHolder generatorIdentityHolder, Mode mode) {
        this(generatorIdentityHolder, null, mode);
    }

    public BaseUniqueIDGenerator(GeneratorIdentityHolder generatorIdentityHolder, Clock clock, Mode mode) {
        this.generatorIdentityHolder = generatorIdentityHolder;
        this.clock = clock == null ? System::currentTimeMillis : clock;
        this.mode = mode == null ? Mode.defaultMode() : mode;
    }

    @Override
    public synchronized byte[] generate() throws GeneratorException {
        return this.generate(0);
    }

    synchronized byte[] generate(int attempt) throws GeneratorException {
        if (attempt > 10) {
            throw new GeneratorException("Clock supplied to generator failed to progress.");
        }
        long now = this.clock.currentTimeMillis();
        this.sequence = now == this.previousTimestamp ? ++this.sequence : 0;
        if (this.sequence > 63) {
            try {
                TimeUnit.MICROSECONDS.sleep(400L);
                return this.generate(attempt + 1);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.previousTimestamp = now;
        Blueprint blueprint = new Blueprint(now, this.sequence, this.generatorIdentityHolder.getGeneratorId(), this.generatorIdentityHolder.getClusterId(), this.mode);
        return IDBuilder.build(blueprint);
    }

    @Override
    public Deque<byte[]> batch(int size) throws GeneratorException {
        ArrayDeque<byte[]> stack = new ArrayDeque<byte[]>();
        for (int i = 0; i < size; ++i) {
            stack.add(this.generate());
        }
        return stack;
    }

    @Override
    public void close() throws IOException {
        this.generatorIdentityHolder.close();
    }
}

