/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.GeneratorIdentityHolder;
import org.lable.oss.uniqueid.etcd.ClusterID;
import org.lable.oss.uniqueid.etcd.ExpiringResourceClaim;
import org.lable.oss.uniqueid.etcd.ResourceClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedGeneratorIdentity
implements GeneratorIdentityHolder {
    private static final Logger logger = LoggerFactory.getLogger(SynchronizedGeneratorIdentity.class);
    private final Client client;
    private final List<Integer> clusterIds;
    private final Supplier<Duration> claimDurationSupplier;
    private final Supplier<Duration> acquisitionTimeoutSupplier;
    ResourceClaim resourceClaim = null;

    public SynchronizedGeneratorIdentity(Client client, List<Integer> clusterIds, Supplier<Duration> claimDurationSupplier, Supplier<Duration> acquisitionTimeoutSupplier) {
        this.client = client;
        this.clusterIds = clusterIds;
        this.claimDurationSupplier = claimDurationSupplier;
        this.acquisitionTimeoutSupplier = acquisitionTimeoutSupplier == null ? () -> null : acquisitionTimeoutSupplier;
    }

    public static SynchronizedGeneratorIdentity basedOn(String endpoints, String namespace, Supplier<Duration> claimDurationSupplier, Supplier<Duration> acquisitionTimeoutSupplier) throws IOException {
        Client client = Client.builder().endpoints(endpoints.split(",")).namespace(ByteSequence.from(namespace, StandardCharsets.UTF_8)).build();
        List<Integer> clusterIds = ClusterID.get(client);
        return new SynchronizedGeneratorIdentity(client, clusterIds, claimDurationSupplier, acquisitionTimeoutSupplier);
    }

    public static SynchronizedGeneratorIdentity basedOn(String endpoints, String namespace, Long claimDuration) throws IOException {
        Client client = Client.builder().endpoints(endpoints.split(",")).namespace(ByteSequence.from(namespace, StandardCharsets.UTF_8)).build();
        List<Integer> clusterIds = ClusterID.get(client);
        Supplier<Duration> durationSupplier = () -> Duration.ofMillis(claimDuration);
        return new SynchronizedGeneratorIdentity(client, clusterIds, durationSupplier, null);
    }

    @Override
    public int getClusterId() throws GeneratorException {
        this.acquireResourceClaim();
        try {
            return this.resourceClaim.getClusterId();
        }
        catch (IllegalStateException e) {
            this.relinquishResourceClaim();
            this.acquireResourceClaim();
            return this.resourceClaim.getClusterId();
        }
    }

    @Override
    public int getGeneratorId() throws GeneratorException {
        this.acquireResourceClaim();
        try {
            return this.resourceClaim.getGeneratorId();
        }
        catch (IllegalStateException e) {
            this.relinquishResourceClaim();
            this.acquireResourceClaim();
            return this.resourceClaim.getGeneratorId();
        }
    }

    public synchronized void relinquishResourceClaim() {
        if (this.resourceClaim == null) {
            return;
        }
        this.resourceClaim.close();
        this.resourceClaim = null;
    }

    private synchronized void acquireResourceClaim() throws GeneratorException {
        if (this.resourceClaim != null) {
            return;
        }
        this.resourceClaim = this.acquireResourceClaim(0);
    }

    private ResourceClaim acquireResourceClaim(int retries) throws GeneratorException {
        try {
            return ExpiringResourceClaim.claimExpiring(this.client, 2048, this.clusterIds, this.claimDurationSupplier == null ? null : this.claimDurationSupplier.get(), this.acquisitionTimeoutSupplier.get());
        }
        catch (IOException e) {
            logger.warn("Connection to Etcd failed, retrying resource claim acquisition, attempt {}.", (Object)(retries + 1));
            if (retries < 3) {
                return this.acquireResourceClaim(retries + 1);
            }
            throw new GeneratorException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.resourceClaim != null) {
            this.resourceClaim.close();
        }
    }
}

