/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.lable.oss.uniqueid.BaseUniqueIDGenerator;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.zookeeper.ClusterID;
import org.lable.oss.uniqueid.zookeeper.ExpiringResourceClaim;
import org.lable.oss.uniqueid.zookeeper.ResourceClaim;
import org.lable.oss.uniqueid.zookeeper.connection.ZooKeeperConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedUniqueIDGenerator
extends BaseUniqueIDGenerator {
    static final Logger logger = LoggerFactory.getLogger(SynchronizedUniqueIDGenerator.class);
    ResourceClaim resourceClaim;
    final int poolSize;
    static ConcurrentMap<String, SynchronizedUniqueIDGenerator> instances = new ConcurrentHashMap<String, SynchronizedUniqueIDGenerator>();

    SynchronizedUniqueIDGenerator(ResourceClaim resourceClaim, int clusterId) {
        super(resourceClaim.get(), clusterId);
        this.poolSize = resourceClaim.poolSize;
        this.resourceClaim = resourceClaim;
    }

    public static synchronized SynchronizedUniqueIDGenerator generatorFor(String zookeeperQuorum, String znode) throws IOException {
        String instanceKey = zookeeperQuorum + "@" + znode;
        if (!instances.containsKey(instanceKey)) {
            ZooKeeperConnection.configure(zookeeperQuorum);
            int clusterId = ClusterID.get(ZooKeeperConnection.get(), znode);
            SynchronizedUniqueIDGenerator.assertParameterWithinBounds((String)"cluster-ID", (long)0L, (long)15L, (long)clusterId);
            logger.debug("Creating new instance.");
            int poolSize = 64;
            ResourceClaim resourceClaim = ExpiringResourceClaim.claimExpiring(ZooKeeperConnection.get(), poolSize, znode);
            instances.putIfAbsent(instanceKey, new SynchronizedUniqueIDGenerator(resourceClaim, clusterId));
        }
        return (SynchronizedUniqueIDGenerator)((Object)instances.get(instanceKey));
    }

    public synchronized byte[] generate() throws GeneratorException {
        try {
            this.generatorId = this.resourceClaim.get();
        }
        catch (IllegalStateException e) {
            String znode = this.resourceClaim.getConfiguredZNode();
            this.resourceClaim.close();
            try {
                this.resourceClaim = ExpiringResourceClaim.claim(ZooKeeperConnection.get(), this.poolSize, znode);
            }
            catch (IOException ioe) {
                throw new GeneratorException((Throwable)ioe);
            }
            this.generatorId = this.resourceClaim.get();
        }
        return super.generate();
    }

    public void relinquishGeneratorIDClaim() {
        this.resourceClaim.close();
    }
}

