/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.ZooKeeper;
import org.lable.oss.uniqueid.zookeeper.ResourceClaim;

public class ExpiringResourceClaim
extends ResourceClaim {
    public static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);

    ExpiringResourceClaim(ZooKeeper zookeeper, int poolSize, String znode, long timeout) throws IOException {
        super(zookeeper, poolSize, znode);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ExpiringResourceClaim.this.close();
            }
        }, timeout);
    }

    public static ResourceClaim claimExpiring(ZooKeeper zookeeper, int poolSize, String znode) throws IOException {
        return ExpiringResourceClaim.claimExpiring(zookeeper, poolSize, znode, DEFAULT_TIMEOUT);
    }

    public static ResourceClaim claimExpiring(ZooKeeper zookeeper, int poolSize, String znode, long timeout) throws IOException {
        return new ExpiringResourceClaim(zookeeper, poolSize, znode, timeout);
    }
}

