/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper.connection;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.lable.oss.uniqueid.zookeeper.connection.ZooKeeperConnectionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ZooKeeperConnection {
    INSTANCE;

    static final Logger logger;
    static final int CONNECTION_TIMEOUT = 10;
    final Queue<ZooKeeperConnectionObserver> observers = new ConcurrentLinkedQueue<ZooKeeperConnectionObserver>();
    ZooKeeper zookeeper = null;
    static String quorumAddresses;

    public static ZooKeeper get() throws IOException {
        if (quorumAddresses == null) {
            throw new RuntimeException("ZooKeeper quorum addresses were never configured.");
        }
        if (ZooKeeperConnection.INSTANCE.zookeeper == null) {
            ZooKeeperConnection.connect();
        }
        return ZooKeeperConnection.INSTANCE.zookeeper;
    }

    public static void shutdown() {
        if (ZooKeeperConnection.INSTANCE.zookeeper == null) {
            return;
        }
        try {
            ZooKeeperConnection.INSTANCE.zookeeper.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            ZooKeeperConnection.INSTANCE.zookeeper = null;
        }
    }

    private static void connect() throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        ZooKeeper zookeeper = new ZooKeeper(quorumAddresses, (int)TimeUnit.SECONDS.toMillis(10L), new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    latch.countDown();
                }
            }
        });
        boolean successfullyConnected = false;
        try {
            successfullyConnected = latch.await(11L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!successfullyConnected) {
            throw new IOException(String.format("Connection to ZooKeeper quorum timed out after %d seconds.", 10));
        }
        zookeeper.register((Watcher)new ConnectionWatcher());
        ZooKeeperConnection.INSTANCE.zookeeper = zookeeper;
    }

    public static void registerObserver(ZooKeeperConnectionObserver observer) {
        ZooKeeperConnection.INSTANCE.observers.add(observer);
    }

    public static void deregisterObserver(ZooKeeperConnectionObserver observer) {
        ZooKeeperConnection.INSTANCE.observers.remove(observer);
    }

    public static void reset() {
        ZooKeeperConnection.INSTANCE.zookeeper = null;
    }

    public static void configure(String quorumAddresses) {
        ZooKeeperConnection.quorumAddresses = quorumAddresses;
    }

    static {
        logger = LoggerFactory.getLogger(ZooKeeperConnection.class);
        quorumAddresses = null;
    }

    static class ConnectionWatcher
    implements Watcher {
        ConnectionWatcher() {
        }

        public void process(WatchedEvent event) {
            switch (event.getState()) {
                case Disconnected: {
                    logger.warn("Disconnected from ZooKeeper quorum.");
                    for (ZooKeeperConnectionObserver observer : ZooKeeperConnection.INSTANCE.observers) {
                        observer.disconnected();
                    }
                    break;
                }
                case Expired: {
                    ZooKeeperConnection.reset();
                    break;
                }
                case SyncConnected: {
                    for (ZooKeeperConnectionObserver observer : ZooKeeperConnection.INSTANCE.observers) {
                        observer.connected();
                    }
                    break;
                }
            }
        }
    }
}

