/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper.connection;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.lable.oss.uniqueid.zookeeper.connection.ZooKeeperConnectionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConnection {
    static final Logger logger = LoggerFactory.getLogger(ZooKeeperConnection.class);
    static final int CONNECTION_TIMEOUT = 10;
    final Queue<ZooKeeperConnectionObserver> observers = new ConcurrentLinkedQueue<ZooKeeperConnectionObserver>();
    final String quorumAddresses;
    ZooKeeper zookeeper = null;

    public ZooKeeperConnection(String quorumAddresses) throws IOException {
        this.zookeeper = this.connect(quorumAddresses);
        this.quorumAddresses = quorumAddresses;
        this.zookeeper.register((Watcher)new ConnectionWatcher(this));
    }

    public ZooKeeper get() throws IOException {
        if (this.zookeeper == null) {
            this.zookeeper = this.connect(this.quorumAddresses);
        }
        return this.zookeeper;
    }

    public void shutdown() {
        if (this.zookeeper == null) {
            return;
        }
        try {
            this.zookeeper.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.zookeeper = null;
        }
    }

    private ZooKeeper connect(String quorumAddresses) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        ZooKeeper zookeeper = new ZooKeeper(quorumAddresses, (int)TimeUnit.SECONDS.toMillis(10L), new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    latch.countDown();
                }
            }
        });
        boolean successfullyConnected = false;
        try {
            successfullyConnected = latch.await(11L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!successfullyConnected) {
            throw new IOException(String.format("Connection to ZooKeeper quorum timed out after %d seconds.", 10));
        }
        return zookeeper;
    }

    public void registerObserver(ZooKeeperConnectionObserver observer) {
        this.observers.add(observer);
    }

    public void deregisterObserver(ZooKeeperConnectionObserver observer) {
        this.observers.remove(observer);
    }

    public void reset() {
        this.zookeeper = null;
    }

    static class ConnectionWatcher
    implements Watcher {
        private final ZooKeeperConnection zooKeeperConnection;

        public ConnectionWatcher(ZooKeeperConnection zooKeeperConnection) {
            this.zooKeeperConnection = zooKeeperConnection;
        }

        public void process(WatchedEvent event) {
            switch (event.getState()) {
                case Disconnected: {
                    logger.warn("Disconnected from ZooKeeper quorum.");
                    for (ZooKeeperConnectionObserver observer : this.zooKeeperConnection.observers) {
                        observer.disconnected();
                    }
                    break;
                }
                case Expired: {
                    this.zooKeeperConnection.reset();
                    break;
                }
                case SyncConnected: {
                    for (ZooKeeperConnectionObserver observer : this.zooKeeperConnection.observers) {
                        observer.connected();
                    }
                    break;
                }
            }
        }
    }
}

