/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.lable.oss.uniqueid.zookeeper.ResourceClaim;
import org.lable.oss.uniqueid.zookeeper.connection.ZooKeeperConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringResourceClaim
extends ResourceClaim {
    private static final Logger logger = LoggerFactory.getLogger(ExpiringResourceClaim.class);
    public static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);

    ExpiringResourceClaim(ZooKeeperConnection zooKeeperConnection, int poolSize, String znode, long timeout) throws IOException {
        super(zooKeeperConnection, poolSize, znode);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ExpiringResourceClaim.this.close();
            }
        }, timeout);
    }

    public static ResourceClaim claimExpiring(ZooKeeperConnection zooKeeperConnection, int poolSize, String znode) throws IOException {
        return ExpiringResourceClaim.claimExpiring(zooKeeperConnection, poolSize, znode, DEFAULT_TIMEOUT);
    }

    public static ResourceClaim claimExpiring(ZooKeeperConnection zooKeeperConnection, int poolSize, String znode, Long timeout) throws IOException {
        long timeoutNonNull = timeout == null ? DEFAULT_TIMEOUT : timeout;
        logger.debug("Preparing expiring resource-claim; will release it in {}ms.", (Object)timeout);
        return new ExpiringResourceClaim(zooKeeperConnection, poolSize, znode, timeoutNonNull);
    }
}

