/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper;

import java.io.IOException;
import java.time.Duration;
import java.util.function.Supplier;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.GeneratorIdentityHolder;
import org.lable.oss.uniqueid.zookeeper.ClusterID;
import org.lable.oss.uniqueid.zookeeper.ExpiringResourceClaim;
import org.lable.oss.uniqueid.zookeeper.ResourceClaim;
import org.lable.oss.uniqueid.zookeeper.connection.ZooKeeperConnection;

public class SynchronizedGeneratorIdentity
implements GeneratorIdentityHolder {
    final int clusterId;
    final Supplier<Duration> claimDurationSupplier;
    final String zNode;
    final ZooKeeperConnection zooKeeperConnection;
    ResourceClaim resourceClaim = null;

    public SynchronizedGeneratorIdentity(ZooKeeperConnection zooKeeperConnection, String zNode, int clusterId, Supplier<Duration> claimDurationSupplier) {
        this.zooKeeperConnection = zooKeeperConnection;
        this.zNode = zNode;
        this.clusterId = clusterId;
        this.claimDurationSupplier = claimDurationSupplier;
    }

    public static SynchronizedGeneratorIdentity basedOn(String quorum, String znode, Supplier<Duration> claimDurationSupplier) throws IOException {
        ZooKeeperConnection zooKeeperConnection = new ZooKeeperConnection(quorum);
        int clusterId = ClusterID.get(zooKeeperConnection.get(), znode);
        return new SynchronizedGeneratorIdentity(zooKeeperConnection, znode, clusterId, claimDurationSupplier);
    }

    public static SynchronizedGeneratorIdentity basedOn(String quorum, String znode, Long claimDuration) throws IOException {
        ZooKeeperConnection zooKeeperConnection = new ZooKeeperConnection(quorum);
        int clusterId = ClusterID.get(zooKeeperConnection.get(), znode);
        Supplier<Duration> durationSupplier = () -> Duration.ofMillis(claimDuration);
        return new SynchronizedGeneratorIdentity(zooKeeperConnection, znode, clusterId, durationSupplier);
    }

    public int getClusterId() throws GeneratorException {
        return this.clusterId;
    }

    public int getGeneratorId() throws GeneratorException {
        if (this.resourceClaim == null) {
            this.resourceClaim = this.acquireResourceClaim();
        }
        try {
            return this.resourceClaim.get();
        }
        catch (IllegalStateException e) {
            this.resourceClaim.close();
            this.resourceClaim = this.acquireResourceClaim();
            return this.resourceClaim.get();
        }
    }

    public String getZNode() {
        return this.zNode;
    }

    public void relinquishGeneratorIdClaim() {
        this.resourceClaim.close();
        this.resourceClaim = null;
    }

    private ResourceClaim acquireResourceClaim() throws GeneratorException {
        Long claimDuration = SynchronizedGeneratorIdentity.getDurationInMillis(this.claimDurationSupplier);
        try {
            return ExpiringResourceClaim.claimExpiring(this.zooKeeperConnection, 256, this.zNode, claimDuration);
        }
        catch (IOException e) {
            throw new GeneratorException((Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.resourceClaim != null) {
            this.resourceClaim.close();
        }
    }

    static Long getDurationInMillis(Supplier<Duration> durationSupplier) {
        if (durationSupplier == null) {
            return null;
        }
        Duration duration = durationSupplier.get();
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }
}

