/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper.connection;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.lable.oss.uniqueid.zookeeper.connection.ZooKeeperConnectionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConnection {
    static final Logger logger = LoggerFactory.getLogger(ZooKeeperConnection.class);
    static final int CONNECTION_TIMEOUT = 10;
    static final int CONNECTION_RETRY_LIMIT = 3;
    final Queue<ZooKeeperConnectionObserver> observers = new ConcurrentLinkedQueue<ZooKeeperConnectionObserver>();
    final String quorumAddresses;
    ZooKeeper zookeeper = null;

    public ZooKeeperConnection(String quorumAddresses) throws IOException {
        this.zookeeper = this.connect(quorumAddresses);
        this.quorumAddresses = quorumAddresses;
        this.zookeeper.register((Watcher)new ConnectionWatcher(this));
    }

    public synchronized ZooKeeper getActiveConnection() throws IOException {
        if (!ZooKeeperConnection.isConnected(this.zookeeper)) {
            this.reset();
            return this.get();
        }
        return this.zookeeper;
    }

    public synchronized ZooKeeper get() throws IOException {
        if (this.zookeeper == null) {
            this.attemptConnection(3);
        }
        return this.zookeeper;
    }

    private void attemptConnection(int tries) throws IOException {
        this.attemptConnection(tries, tries);
    }

    private void attemptConnection(int tries, int triesRemaining) throws IOException {
        if (triesRemaining <= 0) {
            throw new IOException(String.format("Failed to (re)connect to ZooKeeper quorum after %d tries.", tries));
        }
        logger.info("Attempting to (re)connect to ZooKeeper quorum ({} tries remaining).", (Object)triesRemaining);
        --triesRemaining;
        this.zookeeper = this.connect(this.quorumAddresses);
        if (!ZooKeeperConnection.isConnected(this.zookeeper)) {
            this.attemptConnection(triesRemaining);
        }
    }

    static boolean isConnected(ZooKeeper zookeeper) {
        if (zookeeper == null) {
            return false;
        }
        block7: for (int i = 0; i < 5; ++i) {
            switch (zookeeper.getState()) {
                case CONNECTING: 
                case ASSOCIATING: {
                    logger.warn("Establishing (or re-establishing) connection to ZooKeeper quorum.  Patiently waiting a bit ({})\u2026", (Object)(i + 1));
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue block7;
                }
                case CONNECTED: 
                case CONNECTEDREADONLY: {
                    return true;
                }
                case CLOSED: 
                case AUTH_FAILED: 
                case NOT_CONNECTED: {
                    return false;
                }
            }
        }
        return false;
    }

    public void shutdown() {
        if (this.zookeeper == null) {
            return;
        }
        try {
            this.zookeeper.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.zookeeper = null;
        }
    }

    private ZooKeeper connect(String quorumAddresses) throws IOException {
        CountDownLatch latch = new CountDownLatch(1);
        ZooKeeper zookeeper = new ZooKeeper(quorumAddresses, (int)TimeUnit.SECONDS.toMillis(10L), watchedEvent -> {
            if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                latch.countDown();
            }
        });
        boolean successfullyConnected = false;
        try {
            successfullyConnected = latch.await(11L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!successfullyConnected) {
            throw new IOException(String.format("Connection to ZooKeeper quorum timed out after %d seconds.", 10));
        }
        return zookeeper;
    }

    public void registerObserver(ZooKeeperConnectionObserver observer) {
        this.observers.add(observer);
    }

    public void deregisterObserver(ZooKeeperConnectionObserver observer) {
        this.observers.remove(observer);
    }

    public void reset() {
        this.zookeeper = null;
    }

    static class ConnectionWatcher
    implements Watcher {
        private final ZooKeeperConnection zooKeeperConnection;

        public ConnectionWatcher(ZooKeeperConnection zooKeeperConnection) {
            this.zooKeeperConnection = zooKeeperConnection;
        }

        public void process(WatchedEvent event) {
            switch (event.getState()) {
                case Disconnected: {
                    logger.warn("Disconnected from ZooKeeper quorum.");
                    this.zooKeeperConnection.observers.forEach(ZooKeeperConnectionObserver::disconnected);
                    break;
                }
                case Expired: {
                    this.zooKeeperConnection.reset();
                    break;
                }
                case SyncConnected: {
                    this.zooKeeperConnection.observers.forEach(ZooKeeperConnectionObserver::connected);
                    break;
                }
            }
        }
    }
}

