/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.lable.oss.uniqueid.BaseUniqueIDGenerator;
import org.lable.oss.uniqueid.GeneratorIdentityHolder;
import org.lable.oss.uniqueid.IDGenerator;
import org.lable.oss.uniqueid.bytes.Mode;
import org.lable.oss.uniqueid.zookeeper.ClusterID;
import org.lable.oss.uniqueid.zookeeper.SynchronizedGeneratorIdentity;
import org.lable.oss.uniqueid.zookeeper.connection.ZooKeeperConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedUniqueIDGeneratorFactory {
    static final Logger logger = LoggerFactory.getLogger(SynchronizedUniqueIDGeneratorFactory.class);
    static final Map<String, IDGenerator> instances = new HashMap<String, IDGenerator>();

    public static synchronized IDGenerator generatorFor(ZooKeeperConnection zooKeeperConnection, String znode, Mode mode) throws IOException {
        if (!instances.containsKey(znode)) {
            int clusterId = ClusterID.get(zooKeeperConnection.getActiveConnection(), znode);
            SynchronizedGeneratorIdentity generatorIdentityHolder = new SynchronizedGeneratorIdentity(zooKeeperConnection, znode, clusterId, null);
            return SynchronizedUniqueIDGeneratorFactory.generatorFor(generatorIdentityHolder, mode);
        }
        return instances.get(znode);
    }

    public static synchronized IDGenerator generatorFor(SynchronizedGeneratorIdentity synchronizedGeneratorIdentity, Mode mode) throws IOException {
        String instanceKey = synchronizedGeneratorIdentity.getZNode();
        if (!instances.containsKey(instanceKey)) {
            logger.debug("Creating new instance.");
            instances.putIfAbsent(instanceKey, (IDGenerator)new BaseUniqueIDGenerator((GeneratorIdentityHolder)synchronizedGeneratorIdentity, mode));
        }
        return instances.get(instanceKey);
    }
}

