/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper;

import java.io.IOException;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import org.lable.oss.dynamicconfig.zookeeper.MonitoringZookeeperConnection;
import org.lable.oss.uniqueid.zookeeper.ResourceClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringResourceClaim
extends ResourceClaim {
    private static final Logger logger = LoggerFactory.getLogger(ExpiringResourceClaim.class);
    public static final Duration DEFAULT_CLAIM_HOLD = Duration.ofSeconds(30L);
    public static final Duration DEFAULT_ACQUISITION_TIMEOUT = Duration.ofMinutes(10L);

    ExpiringResourceClaim(MonitoringZookeeperConnection zooKeeperConnection, int poolSize, String znode, Duration claimHold, Duration acquisitionTimeout) throws IOException {
        super(zooKeeperConnection, poolSize, znode, acquisitionTimeout);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ExpiringResourceClaim.this.close();
            }
        }, claimHold.toMillis());
    }

    public static ResourceClaim claimExpiring(MonitoringZookeeperConnection zooKeeperConnection, int poolSize, String znode) throws IOException {
        return ExpiringResourceClaim.claimExpiring(zooKeeperConnection, poolSize, znode, DEFAULT_CLAIM_HOLD, DEFAULT_ACQUISITION_TIMEOUT);
    }

    public static ResourceClaim claimExpiring(MonitoringZookeeperConnection zooKeeperConnection, int poolSize, String znode, Duration claimHold, Duration acquisitionTimeout) throws IOException {
        Duration duration = claimHold = claimHold == null ? DEFAULT_CLAIM_HOLD : claimHold;
        if (logger.isDebugEnabled()) {
            logger.debug("Preparing expiring resource-claim; will release it in {}ms.", (Object)claimHold.toMillis());
        }
        return new ExpiringResourceClaim(zooKeeperConnection, poolSize, znode, claimHold, acquisitionTimeout);
    }
}

