/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.uniqueid.zookeeper;

import java.io.IOException;
import java.time.Duration;
import java.util.function.Supplier;
import org.lable.oss.dynamicconfig.zookeeper.MonitoringZookeeperConnection;
import org.lable.oss.uniqueid.GeneratorException;
import org.lable.oss.uniqueid.GeneratorIdentityHolder;
import org.lable.oss.uniqueid.zookeeper.ClusterID;
import org.lable.oss.uniqueid.zookeeper.ExpiringResourceClaim;
import org.lable.oss.uniqueid.zookeeper.ResourceClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedGeneratorIdentity
implements GeneratorIdentityHolder {
    private static final Logger logger = LoggerFactory.getLogger(SynchronizedGeneratorIdentity.class);
    final int clusterId;
    final Supplier<Duration> claimDurationSupplier;
    final Supplier<Duration> acquisitionTimeoutSupplier;
    final String zNode;
    final MonitoringZookeeperConnection zooKeeperConnection;
    ResourceClaim resourceClaim = null;

    public SynchronizedGeneratorIdentity(MonitoringZookeeperConnection zooKeeperConnection, String zNode, int clusterId, Supplier<Duration> claimDurationSupplier, Supplier<Duration> acquisitionTimeoutSupplier) {
        this.zooKeeperConnection = zooKeeperConnection;
        this.zNode = zNode;
        this.clusterId = clusterId;
        this.claimDurationSupplier = claimDurationSupplier;
        this.acquisitionTimeoutSupplier = acquisitionTimeoutSupplier == null ? () -> null : acquisitionTimeoutSupplier;
    }

    public static SynchronizedGeneratorIdentity basedOn(String quorum, String znode, Supplier<Duration> claimDurationSupplier, Supplier<Duration> acquisitionTimeoutSupplier) throws IOException {
        MonitoringZookeeperConnection zooKeeperConnection = new MonitoringZookeeperConnection(quorum.split(","));
        int clusterId = ClusterID.get(zooKeeperConnection.getActiveConnection(), znode);
        return new SynchronizedGeneratorIdentity(zooKeeperConnection, znode, clusterId, claimDurationSupplier, acquisitionTimeoutSupplier);
    }

    public static SynchronizedGeneratorIdentity basedOn(String quorum, String znode, Long claimDuration) throws IOException {
        MonitoringZookeeperConnection zooKeeperConnection = new MonitoringZookeeperConnection(quorum.split(","));
        int clusterId = ClusterID.get(zooKeeperConnection.getActiveConnection(), znode);
        Supplier<Duration> durationSupplier = () -> Duration.ofMillis(claimDuration);
        return new SynchronizedGeneratorIdentity(zooKeeperConnection, znode, clusterId, durationSupplier, null);
    }

    public int getClusterId() throws GeneratorException {
        return this.clusterId;
    }

    public int getGeneratorId() throws GeneratorException {
        if (this.resourceClaim == null) {
            this.resourceClaim = this.acquireResourceClaim();
        }
        try {
            return this.resourceClaim.get();
        }
        catch (IllegalStateException e) {
            this.resourceClaim.close();
            this.resourceClaim = this.acquireResourceClaim();
            return this.resourceClaim.get();
        }
    }

    public String getZNode() {
        return this.zNode;
    }

    public void relinquishGeneratorIdClaim() {
        this.resourceClaim.close();
        this.resourceClaim = null;
    }

    private ResourceClaim acquireResourceClaim() throws GeneratorException {
        return this.acquireResourceClaim(0);
    }

    private ResourceClaim acquireResourceClaim(int retries) throws GeneratorException {
        try {
            return ExpiringResourceClaim.claimExpiring(this.zooKeeperConnection, 256, this.zNode, this.claimDurationSupplier == null ? null : this.claimDurationSupplier.get(), this.acquisitionTimeoutSupplier.get());
        }
        catch (IOException e) {
            logger.warn("Connection to ZooKeeper quorum failed, retrying resource claim acquisition, attempt {}.", (Object)(retries + 1));
            if (retries < 3) {
                return this.acquireResourceClaim(retries + 1);
            }
            throw new GeneratorException((Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.resourceClaim != null) {
            this.resourceClaim.close();
        }
    }

    static Long getDurationInMillis(Supplier<Duration> durationSupplier) {
        if (durationSupplier == null) {
            return null;
        }
        Duration duration = durationSupplier.get();
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }
}

