package org.ladsn.core.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * @文件名：SpringBeanFactory.java
 * @包路径：org.ladsn.netty.server.util
 * @功能描述：SpringBeanFactory
 * @创建人：李瑞金
 * @创建日期：2018年9月12日下午2:12:23
 */
public final class SpringBeanFactory implements ApplicationContextAware {

	private static ApplicationContext context;

	public static DefaultListableBeanFactory getBeanFactory() {
		DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory) context
				.getAutowireCapableBeanFactory();
		return defaultListableBeanFactory;
	}

	public static BeanDefinitionBuilder getBeanDefinitionBuilder(Class<?> c) {
		BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(c);
		return beanDefinitionBuilder;
	}

	/**
	 * @功能描述：动态注册bean
	 * @param beanDefinitionBuilder
	 */
	public static void registerBean(String beanName, BeanDefinitionBuilder beanDefinitionBuilder) {
		getBeanFactory().registerBeanDefinition(beanName, beanDefinitionBuilder.getBeanDefinition());
	}

	/**
	 * @功能描述：删除bean
	 * @param beanName
	 */
	public static void removeBean(String beanName) {
		getBeanFactory().removeBeanDefinition(beanName);
	}

	public static <T> T getBean(Class<T> c) {
		return context.getBean(c);
	}

	public static <T> T getBean(String name, Class<T> clazz) {
		return context.getBean(name, clazz);
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		context = applicationContext;
	}

}
