/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.app.authentication.openid;

import javax.servlet.Filter;
import org.ladsn.security.app.authentication.openid.OpenIdAuthenticationFilter;
import org.ladsn.security.app.authentication.openid.OpenIdAuthenticationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.security.SocialUserDetailsService;
import org.springframework.stereotype.Component;

@Component
public class OpenIdAuthenticationSecurityConfig
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    @Autowired
    private AuthenticationSuccessHandler ladsnAuthenticationSuccessHandler;
    @Autowired
    private AuthenticationFailureHandler ladsnAuthenticationFailureHandler;
    @Autowired
    private SocialUserDetailsService userDetailsService;
    @Autowired
    private UsersConnectionRepository usersConnectionRepository;

    public void configure(HttpSecurity http) throws Exception {
        OpenIdAuthenticationFilter OpenIdAuthenticationFilter2 = new OpenIdAuthenticationFilter();
        OpenIdAuthenticationFilter2.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        OpenIdAuthenticationFilter2.setAuthenticationSuccessHandler(this.ladsnAuthenticationSuccessHandler);
        OpenIdAuthenticationFilter2.setAuthenticationFailureHandler(this.ladsnAuthenticationFailureHandler);
        OpenIdAuthenticationProvider OpenIdAuthenticationProvider2 = new OpenIdAuthenticationProvider();
        OpenIdAuthenticationProvider2.setUserDetailsService(this.userDetailsService);
        OpenIdAuthenticationProvider2.setUsersConnectionRepository(this.usersConnectionRepository);
        http.authenticationProvider((AuthenticationProvider)OpenIdAuthenticationProvider2).addFilterAfter((Filter)OpenIdAuthenticationFilter2, UsernamePasswordAuthenticationFilter.class);
    }
}

