/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.server;

import org.ladsn.security.core.properties.SecurityProperties;
import org.ladsn.security.server.TokenJwtEnhancer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;

@Configuration
public class TokenStoreConfig {

    @Configuration
    @ConditionalOnProperty(prefix="ladsn.security.oauth2", name={"tokenStore"}, havingValue="jwt", matchIfMissing=true)
    public static class JwtConfig {
        @Autowired
        private SecurityProperties securityProperties;

        @Bean
        public TokenStore jwtTokenStore() {
            return new JwtTokenStore(this.jwtAccessTokenConverter());
        }

        @Bean
        public JwtAccessTokenConverter jwtAccessTokenConverter() {
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            converter.setSigningKey(this.securityProperties.getOauth2().getJwtSigningKey());
            return converter;
        }

        @Bean
        @ConditionalOnBean(value={TokenEnhancer.class})
        public TokenEnhancer jwtTokenEnhancer() {
            return new TokenJwtEnhancer();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="ladsn.security.oauth2", name={"tokenStore"}, havingValue="redis")
    public static class RedisConfig {
        @Autowired
        private RedisConnectionFactory redisConnectionFactory;

        @Bean
        public TokenStore redisTokenStore() {
            return new RedisTokenStore(this.redisConnectionFactory);
        }
    }
}

