/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.ladsn.security.rbac.domain.ResourceType;
import org.ladsn.security.rbac.domain.User;
import org.ladsn.security.rbac.dto.ResourceInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.data.annotation.CreatedDate;

@Entity
public class Resource {
    @Id
    @GeneratedValue
    private Long id;
    @Temporal(value=TemporalType.TIMESTAMP)
    @CreatedDate
    private Date createdTime;
    private String name;
    private String link;
    private String icon;
    @Enumerated(value=EnumType.STRING)
    private ResourceType type;
    @ElementCollection
    private Set<String> urls;
    @ManyToOne
    private Resource parent;
    @OneToMany(mappedBy="parent")
    @OrderBy(value="sort ASC")
    private List<Resource> childs = new ArrayList<Resource>();
    private int sort;

    public ResourceInfo toTree(User user) {
        ResourceInfo result = new ResourceInfo();
        BeanUtils.copyProperties((Object)this, (Object)result);
        Set<Long> resourceIds = user.getAllResourceIds();
        ArrayList<ResourceInfo> children = new ArrayList<ResourceInfo>();
        for (Resource child : this.getChilds()) {
            if (!StringUtils.equals((String)user.getUsername(), (String)"admin") && !resourceIds.contains(child.getId())) continue;
            children.add(child.toTree(user));
        }
        result.setChildren(children);
        return result;
    }

    public void addChild(Resource child) {
        this.childs.add(child);
        child.setParent(this);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getUrls() {
        return this.urls;
    }

    public void setUrls(Set<String> urls) {
        this.urls = urls;
    }

    public Resource getParent() {
        return this.parent;
    }

    public void setParent(Resource parent) {
        this.parent = parent;
    }

    public List<Resource> getChilds() {
        return this.childs;
    }

    public void setChilds(List<Resource> childs) {
        this.childs = childs;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }
}

