/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.domain;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.ladsn.security.rbac.domain.Resource;
import org.ladsn.security.rbac.domain.RoleResource;
import org.ladsn.security.rbac.domain.RoleUser;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
public class User
implements UserDetails {
    private static final long serialVersionUID = -3521673552808391992L;
    @Id
    @GeneratedValue
    private Long id;
    @Temporal(value=TemporalType.TIMESTAMP)
    @CreatedDate
    private Date createdTime;
    private String username;
    private String password;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<RoleUser> roles = new HashSet<RoleUser>();
    @Transient
    private Set<String> urls = new HashSet<String>();
    @Transient
    private Set<Long> resourceIds = new HashSet<Long>();

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    public Set<Long> getAllResourceIds() {
        this.init(this.resourceIds);
        this.forEachResource(resource -> this.resourceIds.add(resource.getId()));
        return this.resourceIds;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Set<RoleUser> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<RoleUser> roles) {
        this.roles = roles;
    }

    public Set<String> getUrls() {
        this.init(this.urls);
        this.forEachResource(resource -> this.urls.addAll(resource.getUrls()));
        return this.urls;
    }

    private void init(Set<?> data) {
        if (CollectionUtils.isEmpty(data) && data == null) {
            data = new HashSet();
        }
    }

    private void forEachResource(Consumer<Resource> consumer) {
        for (RoleUser role : this.roles) {
            for (RoleResource resource : role.getRole().getResources()) {
                consumer.accept(resource.getResource());
            }
        }
    }

    public void setUrls(Set<String> urls) {
        this.urls = urls;
    }
}

