/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.init;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.ladsn.security.rbac.init.DataInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class SystemDataInitializer
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired(required=false)
    private List<DataInitializer> dataInitializers;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (CollectionUtils.isNotEmpty(this.dataInitializers)) {
            this.dataInitializers.sort((initor1, initor2) -> initor1.getIndex().compareTo(initor2.getIndex()));
            this.dataInitializers.stream().forEach(dataInitializer -> {
                try {
                    dataInitializer.init();
                }
                catch (Exception e) {
                    this.logger.info("\u7cfb\u7edf\u6570\u636e\u521d\u59cb\u5316\u5931\u8d25(" + dataInitializer.getClass().getSimpleName() + ")", (Throwable)e);
                }
            });
        }
    }
}

