/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.init;

import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.ladsn.security.rbac.domain.Resource;
import org.ladsn.security.rbac.domain.ResourceType;
import org.ladsn.security.rbac.domain.Role;
import org.ladsn.security.rbac.domain.RoleUser;
import org.ladsn.security.rbac.domain.User;
import org.ladsn.security.rbac.init.AbstractDataInitializer;
import org.ladsn.security.rbac.repository.ResourceRepository;
import org.ladsn.security.rbac.repository.RoleRepository;
import org.ladsn.security.rbac.repository.RoleUserRepository;
import org.ladsn.security.rbac.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class UserDataInitializer
extends AbstractDataInitializer {
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleUserRepository roleUserRepository;
    @Autowired
    protected ResourceRepository resourceRepository;

    @Override
    public Integer getIndex() {
        return Integer.MIN_VALUE;
    }

    @Override
    protected void doInit() {
        this.initResource();
        Role role = this.initRole();
        this.initAdmin(role);
    }

    private void initAdmin(Role role) {
        User user = new User();
        user.setUsername("admin");
        user.setPassword(this.passwordEncoder.encode((CharSequence)"123456"));
        this.userRepository.save(user);
        RoleUser roleUser = new RoleUser();
        roleUser.setRole(role);
        roleUser.setAdmin(user);
        this.roleUserRepository.save(roleUser);
    }

    private Role initRole() {
        Role role = new Role();
        role.setName("\u8d85\u7ea7\u7ba1\u7406\u5458");
        this.roleRepository.save(role);
        return role;
    }

    protected void initResource() {
        Resource root = this.createRoot("\u6839\u8282\u70b9");
        this.createResource("\u9996\u9875", "", "home", root);
        Resource menu1 = this.createResource("\u5e73\u53f0\u7ba1\u7406", "", "desktop", root);
        this.createResource("\u8d44\u6e90\u7ba1\u7406", "resource", "", menu1);
        this.createResource("\u89d2\u8272\u7ba1\u7406", "role", "", menu1);
        this.createResource("\u7ba1\u7406\u5458\u7ba1\u7406", "admin", "", menu1);
    }

    @Override
    protected boolean isNeedInit() {
        return this.userRepository.count() == 0L;
    }

    protected Resource createRoot(String name) {
        Resource node = new Resource();
        node.setName(name);
        this.resourceRepository.save(node);
        return node;
    }

    protected Resource createResource(String name, Resource parent) {
        return this.createResource(name, null, null, parent);
    }

    protected Resource createResource(String name, String link, String iconName, Resource parent) {
        Resource node = new Resource();
        node.setName(name);
        node.setIcon(iconName);
        node.setParent(parent);
        node.setType(ResourceType.MENU);
        if (StringUtils.isNotBlank((String)link)) {
            node.setLink(link + "Manage");
            HashSet<String> urls = new HashSet<String>();
            urls.add(link + "Manage");
            urls.add("/" + link + "/**");
            node.setUrls(urls);
        }
        this.resourceRepository.save(node);
        return node;
    }
}

