/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.repository.support;

import java.util.Collection;
import java.util.Date;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.ladsn.security.rbac.repository.support.QueryWraper;

public abstract class AbstractConditionBuilder<T> {
    protected void addInConditionToColumn(QueryWraper<T> queryWraper, String column, Object values) {
        if (this.needAddCondition(values)) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            if (values.getClass().isArray()) {
                queryWraper.addPredicate(fieldPath.in((Object[])values));
            } else if (values instanceof Collection) {
                queryWraper.addPredicate(fieldPath.in((Collection)values));
            }
        }
    }

    protected void addBetweenConditionToColumn(QueryWraper<T> queryWraper, String column, Comparable minValue, Comparable maxValue) {
        if (minValue != null || maxValue != null) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            if (minValue != null && maxValue != null) {
                queryWraper.addPredicate(queryWraper.getCb().between((Expression)fieldPath, minValue, this.processMaxValueOnDate(maxValue)));
            } else if (minValue != null) {
                queryWraper.addPredicate(queryWraper.getCb().greaterThanOrEqualTo((Expression)fieldPath, minValue));
            } else if (maxValue != null) {
                queryWraper.addPredicate(queryWraper.getCb().lessThanOrEqualTo((Expression)fieldPath, this.processMaxValueOnDate(maxValue)));
            }
        }
    }

    private Comparable processMaxValueOnDate(Comparable maxValue) {
        if (maxValue instanceof Date) {
            maxValue = new DateTime((Object)maxValue).withTimeAtStartOfDay().plusDays(1).plusSeconds(-1).toDate();
        }
        return maxValue;
    }

    protected void addGreaterThanConditionToColumn(QueryWraper<T> queryWraper, String column, Comparable minValue) {
        if (minValue != null) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            queryWraper.addPredicate(queryWraper.getCb().greaterThan((Expression)fieldPath, minValue));
        }
    }

    protected void addGreaterThanOrEqualConditionToColumn(QueryWraper<T> queryWraper, String column, Comparable minValue) {
        if (minValue != null) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            queryWraper.addPredicate(queryWraper.getCb().greaterThanOrEqualTo((Expression)fieldPath, minValue));
        }
    }

    protected void addLessThanConditionToColumn(QueryWraper<T> queryWraper, String column, Comparable maxValue) {
        if (maxValue != null) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            queryWraper.addPredicate(queryWraper.getCb().lessThan((Expression)fieldPath, this.processMaxValueOnDate(maxValue)));
        }
    }

    protected void addLessThanOrEqualConditionToColumn(QueryWraper<T> queryWraper, String column, Comparable maxValue) {
        if (maxValue != null) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            queryWraper.addPredicate(queryWraper.getCb().lessThanOrEqualTo((Expression)fieldPath, this.processMaxValueOnDate(maxValue)));
        }
    }

    protected void addLikeConditionToColumn(QueryWraper<T> queryWraper, String column, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            queryWraper.addPredicate(this.createLikeCondition(queryWraper, column, value));
        }
    }

    protected Predicate createLikeCondition(QueryWraper<T> queryWraper, String column, String value) {
        Path fieldPath = this.getPath(queryWraper.getRoot(), column);
        Predicate condition = queryWraper.getCb().like((Expression)fieldPath, "%" + value + "%");
        return condition;
    }

    protected void addStartsWidthConditionToColumn(QueryWraper<T> queryWraper, String column, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            queryWraper.addPredicate(queryWraper.getCb().like((Expression)fieldPath, value + "%"));
        }
    }

    protected void addEqualsConditionToColumn(QueryWraper<T> queryWraper, String column, Object value) {
        if (this.needAddCondition(value)) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            queryWraper.addPredicate(queryWraper.getCb().equal((Expression)fieldPath, value));
        }
    }

    protected void addNotEqualsConditionToColumn(QueryWraper<T> queryWraper, String column, Object value) {
        if (this.needAddCondition(value)) {
            Path fieldPath = this.getPath(queryWraper.getRoot(), column);
            queryWraper.addPredicate(queryWraper.getCb().notEqual((Expression)fieldPath, value));
        }
    }

    protected Path getPath(Root root, String property) {
        String[] names = StringUtils.split((String)property, (String)".");
        Path path = root.get(names[0]);
        for (int i = 1; i < names.length; ++i) {
            path = path.get(names[i]);
        }
        return path;
    }

    protected boolean needAddCondition(Object value) {
        boolean addCondition = false;
        if (value != null) {
            if (value instanceof String) {
                if (StringUtils.isNotBlank((String)value.toString())) {
                    addCondition = true;
                }
            } else if (value.getClass().isArray()) {
                if (ArrayUtils.isNotEmpty((Object[])((Object[])value))) {
                    addCondition = true;
                }
            } else if (value instanceof Collection) {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)value))) {
                    addCondition = true;
                }
            } else {
                addCondition = true;
            }
        }
        return addCondition;
    }
}

