/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.repository.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.ladsn.security.rbac.repository.support.Domain2InfoConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class QueryResultConverter {
    private static Logger logger = LoggerFactory.getLogger(QueryResultConverter.class);

    public static <T, I> Page<I> convert(Page<T> pageData, Class<I> clazz, Pageable pageable) {
        List contents = pageData.getContent();
        List<I> infos = QueryResultConverter.convert(contents, clazz);
        return new PageImpl(infos, pageable, pageData.getTotalElements());
    }

    public static <I, T> List<I> convert(List<T> contents, Class<I> clazz) {
        ArrayList<Object> infos = new ArrayList<Object>();
        for (T domain : contents) {
            Object info = null;
            try {
                info = clazz.newInstance();
                BeanUtils.copyProperties(info, domain);
            }
            catch (Exception e) {
                logger.info("\u8f6c\u6362\u6570\u636e\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("\u8f6c\u6362\u6570\u636e\u5931\u8d25");
            }
            if (info == null) continue;
            infos.add(info);
        }
        return infos;
    }

    public static <T, I> Page<I> convert(Page<T> pageData, Pageable pageable, Domain2InfoConverter<T, I> converter) {
        List contents = pageData.getContent();
        List<I> infos = QueryResultConverter.convert(contents, converter);
        return new PageImpl(infos, pageable, pageData.getTotalElements());
    }

    public static <I, T> List<I> convert(List<T> contents, Domain2InfoConverter<T, I> converter) {
        ArrayList<Object> infos = new ArrayList<Object>();
        for (T domain : contents) {
            infos.add(converter.convert(domain));
        }
        return infos;
    }
}

