/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.service.impl;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.ladsn.security.rbac.domain.User;
import org.ladsn.security.rbac.service.RbacService;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component(value="rbacService")
public class RbacServiceImpl
implements RbacService {
    private AntPathMatcher antPathMatcher = new AntPathMatcher();

    @Override
    public boolean hasPermission(HttpServletRequest request, Authentication authentication) {
        Object principal = authentication.getPrincipal();
        boolean hasPermission = false;
        if (principal instanceof User) {
            if (StringUtils.equals((String)((User)principal).getUsername(), (String)"admin")) {
                hasPermission = true;
            } else {
                Set<String> urls = ((User)principal).getUrls();
                for (String url : urls) {
                    if (!this.antPathMatcher.match(url, request.getRequestURI())) continue;
                    hasPermission = true;
                    break;
                }
            }
        }
        return hasPermission;
    }
}

