/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.service.impl;

import java.util.List;
import org.ladsn.security.rbac.domain.Resource;
import org.ladsn.security.rbac.domain.User;
import org.ladsn.security.rbac.dto.ResourceInfo;
import org.ladsn.security.rbac.repository.ResourceRepository;
import org.ladsn.security.rbac.repository.UserRepository;
import org.ladsn.security.rbac.service.ResourceService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ResourceServiceImpl
implements ResourceService {
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private UserRepository userRepository;

    @Override
    public ResourceInfo getTree(Long adminId) {
        User user = (User)this.userRepository.getOne(adminId);
        return this.resourceRepository.findByName("\u6839\u8282\u70b9").toTree(user);
    }

    @Override
    public ResourceInfo getInfo(Long id) {
        Resource resource = (Resource)this.resourceRepository.getOne(id);
        ResourceInfo resourceInfo = new ResourceInfo();
        BeanUtils.copyProperties((Object)resource, (Object)resourceInfo);
        return resourceInfo;
    }

    @Override
    public ResourceInfo create(ResourceInfo info) {
        Resource parent = (Resource)this.resourceRepository.getOne(info.getParentId());
        if (parent == null) {
            parent = this.resourceRepository.findByName("\u6839\u8282\u70b9");
        }
        Resource resource = new Resource();
        BeanUtils.copyProperties((Object)info, (Object)resource);
        parent.addChild(resource);
        info.setId(((Resource)this.resourceRepository.save(resource)).getId());
        return info;
    }

    @Override
    public ResourceInfo update(ResourceInfo info) {
        Resource resource = (Resource)this.resourceRepository.getOne(info.getId());
        BeanUtils.copyProperties((Object)info, (Object)resource);
        return info;
    }

    @Override
    public void delete(Long id) {
        this.resourceRepository.deleteById(id);
    }

    @Override
    public Long move(Long id, boolean up) {
        Resource resource = (Resource)this.resourceRepository.getOne(id);
        int index = resource.getSort();
        List<Resource> childs = resource.getParent().getChilds();
        for (int i = 0; i < childs.size(); ++i) {
            Resource current = childs.get(i);
            if (!current.getId().equals(id)) continue;
            if (up) {
                if (i == 0) continue;
                Resource pre = childs.get(i - 1);
                resource.setSort(pre.getSort());
                pre.setSort(index);
                this.resourceRepository.save(pre);
                continue;
            }
            if (i == childs.size() - 1) continue;
            Resource next = childs.get(i + 1);
            resource.setSort(next.getSort());
            next.setSort(index);
            this.resourceRepository.save(next);
        }
        this.resourceRepository.save(resource);
        return resource.getParent().getId();
    }
}

