/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.service.impl;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.ladsn.security.rbac.domain.Resource;
import org.ladsn.security.rbac.domain.Role;
import org.ladsn.security.rbac.domain.RoleResource;
import org.ladsn.security.rbac.dto.RoleInfo;
import org.ladsn.security.rbac.repository.ResourceRepository;
import org.ladsn.security.rbac.repository.RoleRepository;
import org.ladsn.security.rbac.repository.RoleResourceRepository;
import org.ladsn.security.rbac.repository.support.QueryResultConverter;
import org.ladsn.security.rbac.service.RoleService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private RoleResourceRepository roleResourceRepository;

    @Override
    public RoleInfo create(RoleInfo info) {
        Role role = new Role();
        BeanUtils.copyProperties((Object)info, (Object)role);
        info.setId(((Role)this.roleRepository.save(role)).getId());
        return info;
    }

    @Override
    public RoleInfo update(RoleInfo info) {
        Role role = (Role)this.roleRepository.getOne(info.getId());
        BeanUtils.copyProperties((Object)info, (Object)role);
        return info;
    }

    @Override
    public void delete(Long id) {
        Role role = (Role)this.roleRepository.getOne(id);
        if (CollectionUtils.isNotEmpty(role.getAdmins())) {
            throw new RuntimeException("\u4e0d\u80fd\u5220\u9664\u6709\u4e0b\u6302\u7528\u6237\u7684\u89d2\u8272");
        }
        this.roleRepository.deleteById(id);
    }

    @Override
    public RoleInfo getInfo(Long id) {
        Role role = (Role)this.roleRepository.getOne(id);
        RoleInfo info = new RoleInfo();
        BeanUtils.copyProperties((Object)role, (Object)info);
        return info;
    }

    @Override
    public List<RoleInfo> findAll() {
        return QueryResultConverter.convert(this.roleRepository.findAll(), RoleInfo.class);
    }

    @Override
    public String[] getRoleResources(Long id) {
        Role role = (Role)this.roleRepository.getOne(id);
        HashSet<String> resourceIds = new HashSet<String>();
        for (RoleResource resource : role.getResources()) {
            resourceIds.add(resource.getResource().getId().toString());
        }
        return resourceIds.toArray(new String[resourceIds.size()]);
    }

    @Override
    public void setRoleResources(Long roleId, String resourceIds) {
        String[] resourceIdArray;
        resourceIds = StringUtils.removeEnd((String)resourceIds, (String)",");
        Role role = (Role)this.roleRepository.getOne(roleId);
        this.roleResourceRepository.deleteAll(role.getResources());
        for (String resourceId : resourceIdArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)resourceIds, (String)",")) {
            RoleResource roleResource = new RoleResource();
            roleResource.setRole(role);
            roleResource.setResource((Resource)this.resourceRepository.getOne(new Long(resourceId)));
            this.roleResourceRepository.save(roleResource);
        }
    }
}

