/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.service.impl;

import org.apache.commons.collections.CollectionUtils;
import org.ladsn.security.rbac.domain.Role;
import org.ladsn.security.rbac.domain.RoleUser;
import org.ladsn.security.rbac.domain.User;
import org.ladsn.security.rbac.dto.UserCondition;
import org.ladsn.security.rbac.dto.UserInfo;
import org.ladsn.security.rbac.repository.RoleRepository;
import org.ladsn.security.rbac.repository.RoleUserRepository;
import org.ladsn.security.rbac.repository.UserRepository;
import org.ladsn.security.rbac.repository.spec.UserSpec;
import org.ladsn.security.rbac.repository.support.QueryResultConverter;
import org.ladsn.security.rbac.service.UserService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleUserRepository roleUserRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @Override
    public UserInfo create(UserInfo userInfo) {
        User user = new User();
        BeanUtils.copyProperties((Object)userInfo, (Object)user);
        user.setPassword(this.passwordEncoder.encode((CharSequence)"123456"));
        this.userRepository.save(user);
        userInfo.setId(user.getId());
        this.createRoleAdmin(userInfo, user);
        return userInfo;
    }

    @Override
    public UserInfo update(UserInfo userInfo) {
        User user = (User)this.userRepository.getOne(userInfo.getId());
        BeanUtils.copyProperties((Object)userInfo, (Object)user);
        this.createRoleAdmin(userInfo, user);
        return userInfo;
    }

    private void createRoleAdmin(UserInfo userInfo, User user) {
        if (CollectionUtils.isNotEmpty(user.getRoles())) {
            this.roleUserRepository.deleteAll(user.getRoles());
        }
        RoleUser roleUser = new RoleUser();
        roleUser.setRole((Role)this.roleRepository.getOne(userInfo.getRoleId()));
        roleUser.setAdmin(user);
        this.roleUserRepository.save(roleUser);
    }

    @Override
    public void delete(Long id) {
        this.userRepository.deleteById(id);
    }

    @Override
    public UserInfo getInfo(Long id) {
        User user = (User)this.userRepository.getOne(id);
        UserInfo info = new UserInfo();
        BeanUtils.copyProperties((Object)user, (Object)info);
        return info;
    }

    @Override
    public Page<UserInfo> query(UserCondition condition, Pageable pageable) {
        Page users = this.userRepository.findAll(new UserSpec(condition), pageable);
        return QueryResultConverter.convert(users, UserInfo.class, pageable);
    }
}

