/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.web.controller;

import org.ladsn.security.rbac.domain.User;
import org.ladsn.security.rbac.dto.ResourceInfo;
import org.ladsn.security.rbac.service.ResourceService;
import org.ladsn.security.rbac.web.controller.support.SimpleResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resource"})
public class ResourceController {
    @Autowired
    private ResourceService resourceService;

    @GetMapping
    public ResourceInfo getTree(@AuthenticationPrincipal User user) {
        return this.resourceService.getTree(user.getId());
    }

    @GetMapping(value={"/{id}"})
    public ResourceInfo getInfo(@PathVariable Long id) {
        return this.resourceService.getInfo(id);
    }

    @PostMapping
    public ResourceInfo create(@RequestBody ResourceInfo info) {
        if (info.getParentId() == null) {
            info.setParentId(0L);
        }
        return this.resourceService.create(info);
    }

    @PutMapping(value={"/{id}"})
    public ResourceInfo update(@RequestBody ResourceInfo info) {
        return this.resourceService.update(info);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.resourceService.delete(id);
    }

    @PostMapping(value={"/{id}/up"})
    public SimpleResponse moveUp(@PathVariable Long id) {
        return new SimpleResponse(this.resourceService.move(id, true));
    }

    @PostMapping(value={"/{id}/down"})
    public SimpleResponse moveDown(@PathVariable Long id) {
        return new SimpleResponse(this.resourceService.move(id, false));
    }
}

