/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.web.controller;

import java.util.List;
import org.ladsn.security.rbac.dto.RoleInfo;
import org.ladsn.security.rbac.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"})
public class RoleController {
    @Autowired
    private RoleService roleService;

    @PostMapping
    public RoleInfo create(@RequestBody RoleInfo roleInfo) {
        return this.roleService.create(roleInfo);
    }

    @PutMapping(value={"/{id}"})
    public RoleInfo update(@RequestBody RoleInfo roleInfo) {
        return this.roleService.update(roleInfo);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.roleService.delete(id);
    }

    @GetMapping(value={"/{id}"})
    public RoleInfo getInfo(@PathVariable Long id) {
        return this.roleService.getInfo(id);
    }

    @GetMapping
    public List<RoleInfo> findAll() {
        return this.roleService.findAll();
    }

    @GetMapping(value={"/{id}/resource"})
    public String[] getRoleResources(@PathVariable Long id) {
        return this.roleService.getRoleResources(id);
    }

    @PostMapping(value={"/{id}/resource"})
    public void createRoleResource(@PathVariable Long id, String ids) {
        this.roleService.setRoleResources(id, ids);
    }
}

