/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.rbac.web.controller;

import org.ladsn.security.rbac.dto.UserCondition;
import org.ladsn.security.rbac.dto.UserInfo;
import org.ladsn.security.rbac.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin"})
public class UserController {
    @Autowired
    private UserService userService;

    @GetMapping(value={"/me"})
    public UserInfo me(@AuthenticationPrincipal UserDetails user) {
        UserInfo info = new UserInfo();
        info.setUsername(user.getUsername());
        return info;
    }

    @PostMapping
    public UserInfo create(@RequestBody UserInfo userInfo) {
        return this.userService.create(userInfo);
    }

    @PutMapping(value={"/{id}"})
    public UserInfo update(@RequestBody UserInfo userInfo) {
        return this.userService.update(userInfo);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.userService.delete(id);
    }

    @GetMapping(value={"/{id}"})
    public UserInfo getInfo(@PathVariable Long id) {
        return this.userService.getInfo(id);
    }

    @GetMapping
    public Page<UserInfo> query(UserCondition condition, Pageable pageable) {
        return this.userService.query(condition, pageable);
    }
}

