package org.ladsn.tool.aop.proxy;

import org.ladsn.tool.aop.aspects.Aspect;
import org.ladsn.tool.aop.interceptor.CglibInterceptor;

import net.sf.cglib.proxy.Enhancer;

/**
 * 基于Cglib的切面代理工厂
 * 
 * @author looly
 *
 */
public class CglibProxyFactory extends ProxyFactory{

	@Override
	@SuppressWarnings("unchecked")
	public <T> T proxy(T target, Aspect aspect) {
		final Enhancer enhancer = new Enhancer();
		enhancer.setSuperclass(target.getClass());
		enhancer.setCallback(new CglibInterceptor(target, aspect));
		return (T) enhancer.create();
	}

}
