package org.ladsn.tool.aop.proxy;

import org.ladsn.tool.aop.ProxyUtil;
import org.ladsn.tool.aop.aspects.Aspect;
import org.ladsn.tool.aop.interceptor.JdkInterceptor;

/**
 * JDK实现的切面代理
 * 
 * @author looly
 *
 */
public class JdkProxyFactory extends ProxyFactory{

	@Override
	@SuppressWarnings("unchecked")
	public <T> T proxy(T target, Aspect aspect) {
		return (T) ProxyUtil.newProxyInstance(target.getClass().getClassLoader(), new JdkInterceptor(target, aspect), target.getClass().getInterfaces());
	}
}
