package org.ladsn.tool.db.dialect.impl;

import org.ladsn.tool.db.Page;
import org.ladsn.tool.db.dialect.DialectName;
import org.ladsn.tool.db.sql.SqlBuilder;
import org.ladsn.tool.db.sql.Wrapper;

/**
 * MySQL方言
 * @author loolly
 *
 */
public class MysqlDialect extends AnsiSqlDialect{
	
	public MysqlDialect() {
		wrapper = new Wrapper('`');
	}

	@Override
	protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
		return find.append(" LIMIT ").append(page.getStartPosition()).append(", ").append(page.getPageSize());
	}
	
	@Override
	public DialectName dialectName() {
		return DialectName.MYSQL;
	}
}
