/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.captcha;

import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ladsn.tool.captcha.ICaptcha;
import org.ladsn.tool.captcha.generator.CodeGenerator;
import org.ladsn.tool.captcha.generator.RandomGenerator;
import org.ladsn.tool.core.codec.Base64;
import org.ladsn.tool.core.io.FileUtil;
import org.ladsn.tool.core.io.IORuntimeException;
import org.ladsn.tool.core.io.IoUtil;
import org.ladsn.tool.core.util.ImageUtil;
import org.ladsn.tool.core.util.StrUtil;

public abstract class AbstractCaptcha
implements ICaptcha {
    private static final long serialVersionUID = 3180820918087507254L;
    protected int width = 100;
    protected int height = 37;
    protected int interfereCount = 15;
    protected Font font;
    protected String code;
    protected byte[] imageBytes;
    protected CodeGenerator generator;

    public AbstractCaptcha(int width, int height, int codeCount, int interfereCount) {
        this(width, height, new RandomGenerator(codeCount), interfereCount);
    }

    public AbstractCaptcha(int width, int height, CodeGenerator generator, int interfereCount) {
        this.width = width;
        this.height = height;
        this.generator = generator;
        this.interfereCount = interfereCount;
        this.font = new Font("Courier", 0, (int)((double)this.height * 0.75));
        this.createCode();
    }

    @Override
    public void createCode() {
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.writePng((Image)this.createImage(this.code), (OutputStream)out);
        this.imageBytes = out.toByteArray();
    }

    protected void generateCode() {
        this.code = this.generator.generate();
    }

    protected abstract Image createImage(String var1);

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean verify(String userInputCode) {
        if (StrUtil.isNotBlank((CharSequence)userInputCode)) {
            return StrUtil.equalsIgnoreCase((CharSequence)this.getCode(), (CharSequence)userInputCode);
        }
        return false;
    }

    public void write(String path) throws IORuntimeException {
        this.write(FileUtil.touch((String)path));
    }

    public void write(File file) throws IORuntimeException {
        try (BufferedOutputStream out = FileUtil.getOutputStream((File)file);){
            this.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public void write(OutputStream out) {
        IoUtil.write((OutputStream)out, (boolean)false, (byte[])this.imageBytes);
    }

    public BufferedImage getImage() {
        if (null == this.imageBytes) {
            this.createCode();
        }
        return ImageUtil.read((InputStream)new ByteArrayInputStream(this.imageBytes));
    }

    public String getImageBase64() {
        return Base64.encode((byte[])this.imageBytes);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public CodeGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(CodeGenerator generator) {
        this.generator = generator;
    }
}

