/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ladsn.tool.core.bean.BeanDesc;
import org.ladsn.tool.core.bean.BeanDescCache;
import org.ladsn.tool.core.bean.BeanException;
import org.ladsn.tool.core.bean.BeanInfoCache;
import org.ladsn.tool.core.bean.BeanPath;
import org.ladsn.tool.core.bean.DynaBean;
import org.ladsn.tool.core.bean.copier.BeanCopier;
import org.ladsn.tool.core.bean.copier.CopyOptions;
import org.ladsn.tool.core.bean.copier.ValueProvider;
import org.ladsn.tool.core.collection.CollUtil;
import org.ladsn.tool.core.convert.Convert;
import org.ladsn.tool.core.lang.Editor;
import org.ladsn.tool.core.lang.Filter;
import org.ladsn.tool.core.map.CaseInsensitiveMap;
import org.ladsn.tool.core.map.MapUtil;
import org.ladsn.tool.core.util.ArrayUtil;
import org.ladsn.tool.core.util.ClassUtil;
import org.ladsn.tool.core.util.ReflectUtil;
import org.ladsn.tool.core.util.StrUtil;

public class BeanUtil {
    public static boolean isBean(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static DynaBean createDynaBean(Object bean) {
        return new DynaBean(bean);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static boolean hasNull(Object bean, boolean ignoreError) {
        Field[] fields = ClassUtil.getDeclaredFields(bean.getClass());
        Object fieldValue = null;
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                fieldValue = field.get(bean);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (null != fieldValue) continue;
            return true;
        }
        return false;
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        BeanDesc beanDesc = BeanDescCache.INSTANCE.getBeanDesc(clazz);
        if (null == beanDesc) {
            beanDesc = new BeanDesc(clazz);
            BeanDescCache.INSTANCE.putBeanDesc(clazz, beanDesc);
        }
        return beanDesc;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
        return ArrayUtil.filter(beanInfo.getPropertyDescriptors(), new Filter<PropertyDescriptor>(){

            @Override
            public boolean accept(PropertyDescriptor t) {
                return false == "class".equals(t.getName());
            }
        });
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> map = BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase);
        if (null == map) {
            map = BeanUtil.internalGetPropertyDescriptorMap(clazz, ignoreCase);
            BeanInfoCache.INSTANCE.putPropertyDescriptorMap(clazz, map, ignoreCase);
        }
        return map;
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws BeanException {
        return BeanUtil.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> map = BeanUtil.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        if (null == bean || null == fieldNameOrIndex) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            return CollUtil.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
        }
        if (ArrayUtil.isArray(bean)) {
            return ArrayUtil.get(bean, Integer.parseInt(fieldNameOrIndex));
        }
        return ReflectUtil.getFieldValue(bean, fieldNameOrIndex);
    }

    public static void setFieldValue(Object bean, String fieldNameOrIndex, Object value) {
        if (bean instanceof Map) {
            ((Map)bean).put(fieldNameOrIndex, value);
        } else if (bean instanceof List) {
            CollUtil.setOrAppend((List)bean, Convert.toInt(fieldNameOrIndex), value);
        } else if (ArrayUtil.isArray(bean)) {
            ArrayUtil.setOrAppend(bean, (int)Convert.toInt(fieldNameOrIndex), value);
        } else {
            ReflectUtil.setFieldValue(bean, fieldNameOrIndex, value);
        }
    }

    public static Object getProperty(Object bean, String expression) {
        return BeanPath.create(expression).get(bean);
    }

    public static void setProperty(Object bean, String expression, Object value) {
        BeanPath.create(expression).set(bean, value);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstance(beanClass, new Object[0]), isIgnoreError);
    }

    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMapIgnoreCase(map, ReflectUtil.newInstance(beanClass, new Object[0]), isIgnoreError);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstance(beanClass, new Object[0]), copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean, false, isIgnoreError);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean, isToCamelCase, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean, CopyOptions.create().setIgnoreCase(true).setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, bean, false, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, CopyOptions copyOptions) {
        if (MapUtil.isEmpty(map)) {
            return bean;
        }
        if (isToCamelCase) {
            map = MapUtil.toCamelCaseMap(map);
        }
        return BeanCopier.create(map, bean, copyOptions).copy();
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        return BeanUtil.fillBean(ReflectUtil.newInstance(beanClass, new Object[0]), valueProvider, copyOptions);
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.create(valueProvider, bean, copyOptions).copy();
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return BeanUtil.beanToMap(bean, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return BeanUtil.beanToMap(bean, new HashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, final boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (bean == null) {
            return null;
        }
        return BeanUtil.beanToMap(bean, targetMap, ignoreNullValue, new Editor<String>(){

            @Override
            public String edit(String key) {
                return isToUnderlineCase ? StrUtil.toUnderlineCase(key) : key;
            }
        });
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        if (bean == null) {
            return null;
        }
        Collection<BeanDesc.PropDesc> props = BeanUtil.getBeanDesc(bean.getClass()).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            String key = prop.getFieldName();
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (ignoreNullValue && (null == value || value.equals(bean)) || null == (key = keyEditor.edit(key))) continue;
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtil.copyProperties(source, target, CopyOptions.create());
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtil.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        BeanUtil.copyProperties(source, target, false, copyOptions);
    }

    public static void copyProperties(Object source, Object target, boolean ignoreCase, CopyOptions copyOptions) {
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        BeanCopier.create(source, target, copyOptions).copy();
    }

    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        return ClassUtil.getClassName(bean, isSimple).equals(isSimple ? StrUtil.upperFirst(beanClassName) : beanClassName);
    }

    public static <T> T trimStrFields(T bean, String ... ignoreFields) {
        Field[] fields;
        if (bean == null) {
            return bean;
        }
        for (Field field : fields = ReflectUtil.getFields(bean.getClass())) {
            String trimVal;
            String val;
            if (ignoreFields != null && ArrayUtil.containsIgnoreCase(ignoreFields, field.getName()) || !String.class.equals(field.getType()) || null == (val = (String)ReflectUtil.getFieldValue(bean, field)) || val.equals(trimVal = StrUtil.trim(val))) continue;
            ReflectUtil.setFieldValue(bean, field, (Object)trimVal);
        }
        return bean;
    }

    public static boolean isEmpty(Object bean) {
        if (null != bean) {
            for (Field field : ReflectUtil.getFields(bean.getClass())) {
                if (null == ReflectUtil.getFieldValue(bean, field)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNullField(Object bean) {
        if (null == bean) {
            return true;
        }
        for (Field field : ReflectUtil.getFields(bean.getClass())) {
            if (null != ReflectUtil.getFieldValue(bean, field)) continue;
            return true;
        }
        return false;
    }
}

