/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.bean.copier;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.ladsn.tool.core.bean.BeanDesc;
import org.ladsn.tool.core.bean.BeanUtil;
import org.ladsn.tool.core.bean.copier.CopyOptions;
import org.ladsn.tool.core.bean.copier.ValueProvider;
import org.ladsn.tool.core.bean.copier.provider.BeanValueProvider;
import org.ladsn.tool.core.bean.copier.provider.MapValueProvider;
import org.ladsn.tool.core.collection.CollUtil;
import org.ladsn.tool.core.convert.Convert;
import org.ladsn.tool.core.exceptions.UtilException;
import org.ladsn.tool.core.lang.copier.Copier;
import org.ladsn.tool.core.map.MapUtil;
import org.ladsn.tool.core.util.ObjectUtil;
import org.ladsn.tool.core.util.StrUtil;
import org.ladsn.tool.core.util.TypeUtil;

public class BeanCopier<T>
implements Copier<T> {
    private Object source;
    private T dest;
    private CopyOptions copyOptions;

    public static <T> BeanCopier<T> create(Object source, T dest, CopyOptions copyOptions) {
        return new BeanCopier<T>(source, dest, copyOptions);
    }

    public BeanCopier(Object source, T dest, CopyOptions copyOptions) {
        this.source = source;
        this.dest = dest;
        this.copyOptions = copyOptions;
    }

    @Override
    public T copy() {
        if (null != this.source) {
            if (this.source instanceof ValueProvider) {
                this.valueProviderToBean((ValueProvider)this.source, this.dest);
            } else if (this.source instanceof Map) {
                this.mapToBean((Map)this.source, this.dest);
            } else {
                this.beanToBean(this.source, this.dest);
            }
        }
        return this.dest;
    }

    private void beanToBean(Object providerBean, Object destBean) {
        this.valueProviderToBean(new BeanValueProvider(providerBean, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), destBean);
    }

    private void mapToBean(Map<?, ?> map, Object bean) {
        this.valueProviderToBean(new MapValueProvider(map, this.copyOptions.ignoreCase), bean);
    }

    private void valueProviderToBean(ValueProvider<String> valueProvider, Object bean) {
        if (null == valueProvider) {
            return;
        }
        Class<?> actualEditable = bean.getClass();
        if (this.copyOptions.editable != null) {
            if (!this.copyOptions.editable.isInstance(bean)) {
                throw new IllegalArgumentException(StrUtil.format((CharSequence)"Target class [{}] not assignable to Editable class [{}]", bean.getClass().getName(), this.copyOptions.editable.getName()));
            }
            actualEditable = this.copyOptions.editable;
        }
        HashSet<String> ignoreSet = null != this.copyOptions.ignoreProperties ? CollUtil.newHashSet(this.copyOptions.ignoreProperties) : null;
        Map<String, String> fieldReverseMapping = this.copyOptions.getReversedMapping();
        Collection<BeanDesc.PropDesc> props = BeanUtil.getBeanDesc(actualEditable).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            Method setterMethod;
            String providerKey;
            String fieldName = prop.getFieldName();
            if (CollUtil.contains(ignoreSet, fieldName) || !valueProvider.containsKey(providerKey = BeanCopier.mappingKey(fieldReverseMapping, fieldName)) || null == (setterMethod = prop.getSetter()) || null == (value = valueProvider.value(providerKey, TypeUtil.getFirstParamType(setterMethod))) && this.copyOptions.ignoreNullValue) continue;
            try {
                Class<?> propClass = prop.getFieldClass();
                if (!propClass.isInstance(value) && null == (value = Convert.convert(propClass, value)) && this.copyOptions.ignoreNullValue) continue;
                setterMethod.invoke(bean, value);
            }
            catch (Exception e) {
                if (this.copyOptions.ignoreError) continue;
                throw new UtilException(e, "Inject [{}] error!", prop.getFieldName());
            }
        }
    }

    private static String mappingKey(Map<String, String> fieldReverseMapping, String fieldName) {
        if (MapUtil.isEmpty(fieldReverseMapping)) {
            return fieldName;
        }
        return ObjectUtil.defaultIfNull(fieldReverseMapping.get(fieldName), fieldName);
    }
}

