/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.convert.impl;

import java.util.Map;
import org.ladsn.tool.core.bean.BeanUtil;
import org.ladsn.tool.core.bean.copier.BeanCopier;
import org.ladsn.tool.core.bean.copier.CopyOptions;
import org.ladsn.tool.core.bean.copier.ValueProvider;
import org.ladsn.tool.core.convert.AbstractConverter;
import org.ladsn.tool.core.util.ReflectUtil;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private Class<T> beanClass;
    private CopyOptions copyOptions;

    public BeanConverter(Class<T> beanClass) {
        this(beanClass, CopyOptions.create().setIgnoreError(true));
        this.beanClass = beanClass;
    }

    public BeanConverter(Class<T> beanClass, CopyOptions copyOptions) {
        this.beanClass = beanClass;
        this.copyOptions = copyOptions;
    }

    @Override
    protected T convertInternal(Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtil.isBean(value.getClass())) {
            return BeanCopier.create(value, ReflectUtil.newInstanceIfPossible(this.beanClass), this.copyOptions).copy();
        }
        return null;
    }

    @Override
    public Class<T> getTargetType() {
        return this.beanClass;
    }
}

