/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.convert.impl;

import java.lang.reflect.Type;
import java.util.Collection;
import org.ladsn.tool.core.collection.CollUtil;
import org.ladsn.tool.core.collection.CollectionUtil;
import org.ladsn.tool.core.convert.Converter;
import org.ladsn.tool.core.util.TypeUtil;

public class CollectionConverter
implements Converter<Collection<?>> {
    private final Type collectionType;
    private final Type elementType;

    public CollectionConverter() {
        this(Collection.class);
    }

    public CollectionConverter(Type collectionType) {
        this(collectionType, TypeUtil.getTypeArgument(collectionType));
    }

    public CollectionConverter(Class<?> collectionType) {
        this(collectionType, TypeUtil.getTypeArgument(collectionType));
    }

    public CollectionConverter(Type collectionType, Type elementType) {
        this.collectionType = collectionType;
        this.elementType = elementType;
    }

    @Override
    public Collection<?> convert(Object value, Collection<?> defaultValue) throws IllegalArgumentException {
        Collection<?> result = null;
        try {
            result = this.convertInternal(value);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
        return null == result ? defaultValue : result;
    }

    protected Collection<?> convertInternal(Object value) {
        Collection collection = CollectionUtil.create(TypeUtil.getClass(this.collectionType));
        return CollUtil.addAll(collection, value, this.elementType);
    }
}

