/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.convert.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.ladsn.tool.core.convert.AbstractConverter;
import org.ladsn.tool.core.util.NumberUtil;
import org.ladsn.tool.core.util.StrUtil;

public class NumberConverter
extends AbstractConverter<Number> {
    private Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class<? extends Number> clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    @Override
    protected Number convertInternal(Object value) {
        if (Byte.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            String valueStr = this.convertToStr(value);
            return StrUtil.isBlank(valueStr) ? null : Byte.valueOf(valueStr);
        }
        if (Short.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            String valueStr = this.convertToStr(value);
            return StrUtil.isBlank(valueStr) ? null : Short.valueOf(valueStr);
        }
        if (Integer.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            String valueStr2 = this.convertToStr(value);
            return StrUtil.isBlank(valueStr2) ? null : Integer.valueOf(NumberUtil.parseInt(valueStr2));
        }
        if (AtomicInteger.class == this.targetType) {
            String valueStr;
            if (value instanceof Number) {
                int valueStr2 = ((Number)value).intValue();
            }
            if (StrUtil.isBlank(valueStr = this.convertToStr(value))) {
                return null;
            }
            int intValue = NumberUtil.parseInt(valueStr);
            return new AtomicInteger(intValue);
        }
        if (Long.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            String valueStr3 = this.convertToStr(value);
            return StrUtil.isBlank(valueStr3) ? null : Long.valueOf(NumberUtil.parseLong(valueStr3));
        }
        if (AtomicLong.class == this.targetType) {
            String valueStr;
            if (value instanceof Number) {
                long valueStr3 = ((Number)value).longValue();
            }
            if (StrUtil.isBlank(valueStr = this.convertToStr(value))) {
                return null;
            }
            long longValue = NumberUtil.parseLong(valueStr);
            return new AtomicLong(longValue);
        }
        if (Float.class == this.targetType) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            String valueStr = this.convertToStr(value);
            return StrUtil.isBlank(valueStr) ? null : Float.valueOf(valueStr);
        }
        if (Double.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            String valueStr = this.convertToStr(value);
            return StrUtil.isBlank(valueStr) ? null : Double.valueOf(valueStr);
        }
        if (BigDecimal.class == this.targetType) {
            return this.toBigDecimal(value);
        }
        if (BigInteger.class == this.targetType) {
            return this.toBigInteger(value);
        }
        if (Number.class == this.targetType) {
            if (value instanceof Number) {
                return (Number)value;
            }
            String valueStr = this.convertToStr(value);
            return StrUtil.isBlank(valueStr) ? (Number)null : (Number)NumberUtil.parseNumber(valueStr);
        }
        throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport Number type: {}", this.targetType.getName()));
    }

    private BigDecimal toBigDecimal(Object value) {
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String valueStr = this.convertToStr(value);
        if (StrUtil.isBlank(valueStr)) {
            return null;
        }
        return new BigDecimal(valueStr);
    }

    private BigInteger toBigInteger(Object value) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        String valueStr = this.convertToStr(value);
        if (StrUtil.isBlank(valueStr)) {
            return null;
        }
        return new BigInteger(valueStr);
    }

    @Override
    protected String convertToStr(Object value) {
        return StrUtil.trim(super.convertToStr(value));
    }

    @Override
    public Class<Number> getTargetType() {
        return this.targetType;
    }
}

