/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.convert.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import org.ladsn.tool.core.convert.AbstractConverter;
import org.ladsn.tool.core.convert.ConverterRegistry;
import org.ladsn.tool.core.util.StrUtil;
import org.ladsn.tool.core.util.TypeUtil;

public class ReferenceConverter
extends AbstractConverter<Reference> {
    private Class<? extends Reference> targetType;

    public ReferenceConverter(Class<? extends Reference> targetType) {
        this.targetType = targetType;
    }

    @Override
    protected Reference<?> convertInternal(Object value) {
        Object targetValue = null;
        Type paramType = TypeUtil.getTypeArgument(this.targetType);
        if (null != paramType) {
            targetValue = ConverterRegistry.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (this.targetType == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (this.targetType == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport Reference type: {}", this.targetType.getName()));
    }
}

