/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.date;

import java.util.Date;
import org.ladsn.tool.core.date.DateField;
import org.ladsn.tool.core.date.DateTime;
import org.ladsn.tool.core.date.DateUtil;
import org.ladsn.tool.core.lang.Range;

public class DateRange
extends Range<DateTime> {
    public DateRange(Date start, Date end, DateField unit) {
        this(start, end, unit, 1);
    }

    public DateRange(Date start, Date end, DateField unit, int step) {
        this(start, end, unit, step, true, true);
    }

    public DateRange(Date start, Date end, final DateField unit, final int step, boolean isIncludeStart, boolean isIncludeEnd) {
        super(DateUtil.date(start), DateUtil.date(end), new Range.Steper<DateTime>(){

            @Override
            public DateTime step(DateTime current, DateTime end, int index) {
                DateTime dt = current.offsetNew(unit, step);
                if (dt.isAfter(end)) {
                    return null;
                }
                return current.offsetNew(unit, step);
            }
        }, isIncludeStart, isIncludeEnd);
    }
}

