/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.io;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.ladsn.tool.core.util.StrUtil;

public class BufferUtil {
    public static ByteBuffer copy(ByteBuffer src, int start, int end) {
        return BufferUtil.copy(src, ByteBuffer.allocate(end - start));
    }

    public static ByteBuffer copy(ByteBuffer src, ByteBuffer dest) {
        return BufferUtil.copy(src, dest, Math.min(src.limit(), dest.remaining()));
    }

    public static ByteBuffer copy(ByteBuffer src, ByteBuffer dest, int length) {
        return BufferUtil.copy(src, src.position(), dest, dest.position(), length);
    }

    public static ByteBuffer copy(ByteBuffer src, int srcStart, ByteBuffer dest, int destStart, int length) {
        System.arraycopy(src.array(), srcStart, dest.array(), destStart, length);
        return dest;
    }

    public static byte[] readBytes(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        byte[] ab = new byte[remaining];
        buffer.get(ab);
        return ab;
    }

    public static byte[] readBytes(ByteBuffer buffer, int maxLength) {
        int remaining = buffer.remaining();
        if (maxLength > remaining) {
            maxLength = remaining;
        }
        byte[] ab = new byte[maxLength];
        buffer.get(ab);
        return ab;
    }

    public static byte[] readBytes(ByteBuffer buffer, int start, int end) {
        byte[] bs = new byte[end - start];
        System.arraycopy(buffer.array(), start, bs, 0, bs.length);
        return bs;
    }

    public static int lineEnd(ByteBuffer buffer) {
        return BufferUtil.lineEnd(buffer, buffer.remaining());
    }

    public static int lineEnd(ByteBuffer buffer, int maxLength) {
        int primitivePosition = buffer.position();
        boolean canEnd = false;
        int charIndex = primitivePosition;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            ++charIndex;
            if (b == 13) {
                canEnd = true;
            } else {
                if (b == 10) {
                    return canEnd ? charIndex - 2 : charIndex - 1;
                }
                canEnd = false;
            }
            if (charIndex - primitivePosition <= maxLength) continue;
            buffer.position(primitivePosition);
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Position is out of maxLength: {}", maxLength));
        }
        buffer.position(primitivePosition);
        return -1;
    }

    public static String readLine(ByteBuffer buffer, Charset charset) {
        int startPosition = buffer.position();
        int endPosition = BufferUtil.lineEnd(buffer);
        if (endPosition > startPosition) {
            byte[] bs = BufferUtil.readBytes(buffer, startPosition, endPosition);
            return StrUtil.str(bs, charset);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }
}

