/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.io.file;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.ladsn.tool.core.io.file.FileWriter;
import org.ladsn.tool.core.util.CharsetUtil;

public class FileAppender {
    private FileWriter writer;
    private int capacity;
    private boolean isNewLineMode;
    private List<String> list = new ArrayList<String>(100);

    public FileAppender(File destFile, int capacity, boolean isNewLineMode) {
        this(destFile, CharsetUtil.CHARSET_UTF_8, capacity, isNewLineMode);
    }

    public FileAppender(File destFile, Charset charset, int capacity, boolean isNewLineMode) {
        this.capacity = capacity;
        this.isNewLineMode = isNewLineMode;
        this.writer = FileWriter.create(destFile, charset);
    }

    public FileAppender append(String line) {
        if (this.list.size() >= this.capacity) {
            this.flush();
        }
        this.list.add(line);
        return this;
    }

    public FileAppender flush() {
        try (PrintWriter pw = this.writer.getPrintWriter(true);){
            for (String str : this.list) {
                pw.print(str);
                if (!this.isNewLineMode) continue;
                pw.println();
            }
        }
        this.list.clear();
        return this;
    }
}

