/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.io.resource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.ladsn.tool.core.io.IORuntimeException;
import org.ladsn.tool.core.io.IoUtil;
import org.ladsn.tool.core.io.resource.Resource;
import org.ladsn.tool.core.util.CharsetUtil;

public class InputStreamResource
implements Resource {
    private InputStream in;
    private String name;

    public InputStreamResource(InputStream in) {
        this(in, null);
    }

    public InputStreamResource(InputStream in, String name) {
        this.in = in;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return this.in;
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoUtil.getReader(this.in, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStr(Charset charset) throws IORuntimeException {
        BufferedReader reader = null;
        try {
            reader = this.getReader(charset);
            String string = IoUtil.read(reader);
            return string;
        }
        finally {
            IoUtil.close(reader);
        }
    }

    @Override
    public String readUtf8Str() throws IORuntimeException {
        return this.readStr(CharsetUtil.CHARSET_UTF_8);
    }

    @Override
    public byte[] readBytes() throws IORuntimeException {
        InputStream in = null;
        try {
            in = this.getStream();
            byte[] byArray = IoUtil.readBytes(in);
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }
}

