/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.io.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import org.ladsn.tool.core.collection.CollectionUtil;
import org.ladsn.tool.core.collection.EnumerationIter;
import org.ladsn.tool.core.io.FileUtil;
import org.ladsn.tool.core.io.IORuntimeException;
import org.ladsn.tool.core.io.resource.ClassPathResource;
import org.ladsn.tool.core.io.resource.FileResource;
import org.ladsn.tool.core.io.resource.NoResourceException;
import org.ladsn.tool.core.io.resource.Resource;
import org.ladsn.tool.core.util.ClassLoaderUtil;

public class ResourceUtil {
    public static String readUtf8Str(String resource) {
        return new ClassPathResource(resource).readUtf8Str();
    }

    public static String readStr(String resource, Charset charset) {
        return new ClassPathResource(resource).readStr(charset);
    }

    public static InputStream getStream(String resurce) throws NoResourceException {
        return new ClassPathResource(resurce).getStream();
    }

    public static InputStream getStreamSafe(String resurce) {
        try {
            return new ClassPathResource(resurce).getStream();
        }
        catch (NoResourceException noResourceException) {
            return null;
        }
    }

    public static BufferedReader getReader(String resurce, Charset charset) {
        return new ClassPathResource(resurce).getReader(charset);
    }

    public static URL getResource(String resource) throws IORuntimeException {
        return ResourceUtil.getResource(resource, null);
    }

    public static List<URL> getResources(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassLoaderUtil.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return CollectionUtil.newArrayList(resources);
    }

    public static EnumerationIter<URL> getResourceIter(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassLoaderUtil.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new EnumerationIter<URL>(resources);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        return null != baseClass ? baseClass.getResource(resource) : ClassLoaderUtil.getClassLoader().getResource(resource);
    }

    public static Resource getResourceObj(String path) {
        return FileUtil.isAbsolutePath(path) ? new FileResource(path) : new ClassPathResource(path);
    }
}

