/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.tool.core.lang.caller;

import org.ladsn.tool.core.exceptions.UtilException;
import org.ladsn.tool.core.lang.caller.Caller;

public class StackTraceCaller
implements Caller {
    private static final int OFFSET = 2;

    @Override
    public Class<?> getCaller() {
        String className = Thread.currentThread().getStackTrace()[3].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e, "[{}] not found!", className);
        }
    }

    @Override
    public Class<?> getCallerCaller() {
        String className = Thread.currentThread().getStackTrace()[4].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e, "[{}] not found!", className);
        }
    }

    @Override
    public Class<?> getCaller(int depth) {
        String className = Thread.currentThread().getStackTrace()[2 + depth].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e, "[{}] not found!", className);
        }
    }

    @Override
    public boolean isCalledBy(Class<?> clazz) {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }
}

